<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\Administration\RoleController;
use App\Http\Controllers\Administration\PermissionController;
use App\Http\Controllers\ClinicsController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\HospitalController;
use App\Http\Controllers\PatientController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\SpecialityController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\TermsAndConditionController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware'=>['auth']], function () {
    Route::get('/', 'DashboardController@index')->name('dashboard');
    Route::get('/profile', 'UserController@profile')->name('profile');
    Route::get('/editProfile/{id}', 'UserController@editProfile')->name('editProfile');
    Route::put('/updateProfile/{user}', 'UserController@updateProfile')->name('updateProfile');
});

Route::group(['middleware'=>['auth']], function () {

    //users
    Route::post('addUser/store', [RegisteredUserController::class, 'store'])->name('storeUser');
    Route::get('addUser', [RegisteredUserController::class, 'create'])->name('addUser');
    Route::resource('users', UserController::class);

    //contacts
    Route::resource('contacts', ContactController::class);

    //doctors
    Route::resource('doctors', DoctorController::class);
    Route::get('editDoctor/{id}', [DoctorController::class, 'edit'])->name('doctors.editDoctor');
    Route::post('updateDoctor/{id}', [DoctorController::class, 'updateDoctor'])->name('doctors.updateDoctor');
    Route::get('get-doctors', [DoctorController::class, 'getDoctors'])->name('doctors.get-doctors');
    Route::get('doctor-requests', [DoctorController::class, 'doctorRequests'])->name('doctors.requests');
    Route::get('get-pending-doctors', [DoctorController::class, 'getPendingDoctors'])->name('doctors.pending-list');


    // specialities
    Route::resource('specialities', SpecialityController::class);

    //patients
    Route::resource('patients', PatientController::class);
    Route::PUT('editPatient/{id}', [PatientController::class, 'changeStatus'])->name('patients.editPatient');
    Route::get('get-patients', [PatientController::class, 'getPatients'])->name('patients.get-patients');

    //services
    Route::get('services', [ServiceController::class, 'index'])->name('services.index');
    Route::get('createService', [ServiceController::class, 'create'])->name('services.create');
    Route::post('storeService', [ServiceController::class, 'store'])->name('services.store');
    Route::get('editService/{id}', [ServiceController::class, 'edit'])->name('services.edit');
    Route::post('updateService/{id}', [ServiceController::class, 'update'])->name('services.update');
    Route::get('deleteService/{id}', [ServiceController::class, 'delete'])->name('services.delete');

    //clinics
    Route::get('clinics', [ClinicsController::class, 'index'])->name('clinics.index');
    Route::get('createClinic', [ClinicsController::class, 'create'])->name('clinics.create');
    Route::get('showClinic/{id}', [ClinicsController::class, 'show'])->name('clinics.show');
    Route::post('storeClinic', [ClinicsController::class, 'store'])->name('clinics.store');
    Route::get('editClinic/{id}', [ClinicsController::class, 'edit'])->name('clinics.edit');
    Route::post('updateClinic/{id}', [ClinicsController::class, 'update'])->name('clinics.update');
    Route::get('deleteClinic/{id}', [ClinicsController::class, 'delete'])->name('clinics.delete');
    Route::get('clinic/assign', [ClinicsController::class, 'assign'])->name('clinics.assign');
    Route::post('assignStore', [ClinicsController::class, 'assignStore'])->name('clinicsAssign.store');
    Route::get('deleteDoctor/{id}', [ClinicsController::class, 'deleteDoctor'])->name('deleteDoctor');

    //hospitals
    Route::get('hospitals/assign', [HospitalController::class, 'assign'])->name('hospitals.assign');
    
    Route::post('hospitals/assignStore', [HospitalController::class, 'assignStore'])->name('hospitalsAssign.store');
    Route::resource('hospitals', HospitalController::class);

    // Slider
    Route::resource('sliders', SliderController::class);
    Route::get('hideSlider/{id}', [SliderController::class, 'hideSlider'])->name('hideSlider');

    // Terms and Conditions
    Route::resource('terms', TermsAndConditionController::class);

});

require __DIR__.'/auth.php';

