<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\SpcialityController;
use App\Http\Controllers\Api\DoctorController;
use App\Http\Controllers\Api\HospitalController;
use App\Http\Controllers\Api\PatientController;
use App\Http\Controllers\Api\SliderController;
use App\Http\Controllers\Api\UserController as ApiUserController;
use App\Http\Controllers\Auth\AuthenticatedSessionController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\UserController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});


Route::controller(AuthController::class)->group(function () {
    Route::post('login', 'login');
    Route::post('register', 'register');
    Route::post('logout', 'logout');
    Route::post('refresh', 'refresh');
});

// register doctor
Route::post('createDoctor', [DoctorController::class, 'store'])->name('create-doctor');

// register patient
Route::post('createPatient', [PatientController::class, 'store'])->name('createPatient');

// specialists without auth
Route::get('specialities', [SpcialityController::class, 'index'])->name('specialities');

// Route::group(['middleware' => 'auth:sanctum'], function () {

// Doctors
Route::get('doctors', [DoctorController::class, 'index'])->name('doctors');
Route::post('doctor-profile', [DoctorController::class, 'show'])->name('doctor');
Route::post('doctor-edit', [DoctorController::class, 'update'])->name('doctor-edit');
Route::post('doctor-delete', [DoctorController::class, 'destroy'])->name('doctor-delete');
Route::post('doctor-image', [DoctorController::class, 'doctorImage'])->name('doctor-image');
Route::post('doctor-fileUpload', [DoctorController::class, 'fileUpload'])->name('doctor-fileUpload');
Route::post('doctor-getFiles', [DoctorController::class, 'getFiles'])->name('doctor-getFiles');
Route::get('doctor/showDoctors/{id}', [DoctorController::class, 'showDoctors'])->name('doctor-showDoctors');
Route::post('doctor/filterDoctors', [DoctorController::class, 'filterDoctors'])->name('doctor-filterDoctors');


// patients
Route::post('updatePatient/{id}', [PatientController::class, 'update'])->name('updatePatient');
Route::post('patientChangeStatus/{id}', [PatientController::class, 'changeStatus'])->name('patientChangeStatus');
Route::resource('patients', PatientController::class);

// patients
Route::post('patients', [PatientController::class, 'index'])->name('patients');
Route::post('patient-profile', [PatientController::class, 'show'])->name('patient');
Route::post('patient-edit', [PatientController::class, 'update'])->name('patient-edit');
Route::post('patient-delete', [PatientController::class, 'destroy'])->name('patient-delete');
Route::post('patient-image', [PatientController::class, 'patientImage'])->name('patient-image');

//users
Route::resource('users', ApiUserController::class);
Route::post('checkMobile', [ApiUserController::class, 'checkMobile'])->name('checkMobile');
Route::post('resetPassword', [ApiUserController::class, 'resetPassword'])->name('resetPassword');
Route::post('contactUs',[ContactController::class,'contactUs'])->name('user.contactUs');

//Sliders
Route::get('sliders', [SliderController::class, 'index'])->name('sliders');

// hospitals
Route::resource('hospitals', HospitalController::class);

// Terms and Conditions
Route::get('terms', [\App\Http\Controllers\Api\TermsAndConditionController::class, 'getTerms'])->name('api.terms');

// });
