<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Jewel</title>

    <!-- Google Font: Source Sans Pro -->
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('asset/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- IonIcons -->
    <link rel="stylesheet" href="https://code.ionicframework.com/ionicons/2.0.1/css/ionicons.min.css">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('asset/dist/css/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('asset/plugins/select2/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('asset/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
    <link rel="stylesheet"
        href="{{ asset('asset/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('asset/plugins/bootstrap-colorpicker/css/bootstrap-colorpicker.min.css') }}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/css/iziToast.min.css" />
    <link rel="stylesheet" href=" https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css" />
    <link rel="stylesheet" href="{{ asset('asset/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('asset/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
    <link rel="stylesheet" href="{{ asset('asset/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.css" />


    <link rel="stylesheet"
        href="https://cdnjs.cloudflare.com/ajax/libs/tempusdominus-bootstrap-4/5.38.0/css/tempusdominus-bootstrap-4.min.css"
        crossorigin="anonymous" />

</head>
<style>
    select[name="example1_length"] {
        width: 35% !important;
    }

    .dataTables_length {
        width: 25%;
    }
</style>

<body class="hold-transition sidebar-mini">
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                            class="fas fa-bars"></i></a>
                </li>
            </ul>

            <!-- Right navbar links -->
            <ul class="navbar-nav ml-auto">

                <!-- Notifications Dropdown Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link" data-toggle="dropdown" href="#">
                        <i class="fa fa-cog"></i>

                    </a>
                    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                        <a class="dropdown-item" href="{{ route('sliders.index') }}">
                            Manage Slider
                        </a>
                        <form method="POST" action="{{ route('logout') }}">
                            @csrf
                            <a class="dropdown-item" href="route('logout')"
                                onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                Logout
                            </a>
                        </form>
                    </div>
                </li>
            </ul>
        </nav>
        <!-- /.navbar -->

        <!-- Main Sidebar Container -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- Brand Logo -->
            <a href="{{ route('dashboard') }}" class="brand-link">
                <img src="{{ asset('asset/dist/img/sd.png') }}" alt="sd Logo"
                    class="brand-image img-circle elevation-3" style="opacity: .8">
                <span class="brand-text font-weight-light">Jewel Clinics</span>
            </a>

            <!-- Sidebar -->
            <div class="sidebar">
                <!-- Sidebar user panel (optional) -->
                <div class="user-panel mt-3 pb-3 mb-3 d-flex">
                    <div class="info">
                        <a href="{{ Route('profile') }}" class="d-block">{{ Auth::user()->name }}</a>
                    </div>
                </div>

                <!-- Sidebar Menu -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('users.index') }}"
                                class="nav-link {{ request()->is('users') || request()->is('users/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-users"></i>
                                <p>
                                    Users
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('specialities.index') }}"
                                class="nav-link {{ request()->is('specialities') || request()->is('specialities/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-diagnoses"></i>
                                <p>
                                    Specialities
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('doctors.index') }}"
                                class="nav-link {{ request()->is('doctors') || request()->is('doctors/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-user-md"></i>
                                <p>
                                    Doctors
                                </p>
                            </a>
                        </li>
                    </ul>
                    
                    <ul class="nav nav-pills nav-sidebar flex-column">
                        <li class="nav-item">
                            <a href="{{ route('doctors.requests') }}"
                                class="nav-link {{ request()->is('doctor-requests') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-user-clock"></i>
                                <p>Doctor Requests</p>
                            </a>
                        </li>
                    </ul>

                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('patients.index') }}"
                                class="nav-link {{ request()->is('patients') || request()->is('patients/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-user-injured"></i>
                                <p>
                                    Patients
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('services.index') }}"
                                class="nav-link {{ request()->is('services') || request()->is('services/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-id-card"></i>
                                <p>
                                    Services
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('clinics.index') }}"
                                class="nav-link {{ request()->is('clinics') || request()->is('clinics/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-clinic-medical"></i>
                                <p>
                                    Clinics
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('hospitals.index') }}"
                                class="nav-link {{ request()->is('hospitals') || request()->is('hospitals/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-hospital-alt"></i>
                                <p>
                                    Hospitals
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('contacts.index') }}"
                                class="nav-link {{ request()->is('contacts') || request()->is('contacts/*') ? 'active' : '' }}">
                                <i class="nav-icon fa fa-envelope"></i>
                                <p>
                                    Contacts
                                </p>
                            </a>
                        </li>
                    </ul>
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                        data-accordion="false">
                        <li class="nav-item">
                            <a href="{{ route('terms.index') }}"
                                class="nav-link {{ request()->is('terms') || request()->is('terms/*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-file-contract"></i>
                                <p>
                                    Terms & Conditions
                                </p>
                            </a>
                        </li>
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
            <!-- Content Header (Page header) -->
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">

                        <!-- /.col -->
                        <!-- /.col -->
                    </div>
                    <!-- /.row -->
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <!-- Main content -->
            <div class="content">
                <div class="container-fluid">
                    <div class="row" style="display: block;">
                        @if (session()->has('success'))
                            <div class="alert alert-success">
                                <ul>
                                    <h5>{{ session()->get('success') }}</h5>
                                </ul>
                            </div>
                        @endif

                        @if (session()->has('error'))
                            <div class="alert alert-danger">
                                <ul>
                                    <h5>{{ session()->get('error') }}</h5>
                                </ul>
                            </div>
                        @endif

                        @if ($errors->all())
                            <div class="alert alert-danger">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        {{ Breadcrumbs::render() }}
                        <!-- /.col-md-6 -->
                        @yield('content')
                        <!-- /.col-md-6 -->
                    </div>
                    <!-- /.row -->
                </div>
                <!-- /.container-fluid -->
            </div>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->

        <!-- Control Sidebar -->
        <aside class="control-sidebar control-sidebar-dark">
            <!-- Control sidebar content goes here -->
        </aside>
        <!-- /.control-sidebar -->

        <!-- Main Footer -->
        <footer class="main-footer">
            <strong>Copyright &copy; 2022 <a href="https://sdsolutionseg.com/">SD-Solutions</a>.</strong> All rights
            reserved.
            <div class="float-right d-none d-sm-inline-block">
                <!-- <b>Version</b> 3.2.0 -->
            </div>
        </footer>
    </div>
    <!-- ./wrapper -->

    <!-- REQUIRED SCRIPTS -->

    <!-- jQuery -->
    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <!-- Bootstrap -->
    <script src="{{ asset('asset/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <!-- AdminLTE -->
    <script src="{{ asset('asset/dist/js/adminlte.js') }}"></script>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>


    <!-- ./wrapper -->
    <!-- AdminLTE for demo purposes -->
    <script src="{{ asset('asset/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/jszip/jszip.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/pdfmake/pdfmake.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/pdfmake/vfs_fonts.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-buttons/js/buttons.print.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script>
    <script src="{{ asset('asset/dist/js/adminlte.min.js') }}"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/3.10.2/fullcalendar.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/izitoast/1.4.0/js/iziToast.min.js"></script>

    <!-- OPTIONAL SCRIPTS -->
    <script src="{{ asset('asset/plugins/chart.js/Chart.min.js') }}"></script>
    <!-- AdminLTE dashboard demo (This is only for demo purposes) -->
    <script src="{{ asset('asset/dist/js/pages/dashboard3.js') }}"></script>
    <script src="{{ asset('asset/plugins/select2/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/moment/moment.min.js') }}"></script>
    <script src="{{ asset('asset/plugins/inputmask/jquery.inputmask.min.js') }}"></script>
    <!-- date-range-picker -->
    <script src="{{ asset('asset/plugins/daterangepicker/daterangepicker.js') }}"></script>
    <!-- bootstrap color picker -->
    <script src="{{ asset('asset/plugins/bootstrap-colorpicker/js/bootstrap-colorpicker.min.js') }}"></script>
    <!-- Tempusdominus Bootstrap 4 -->
    <script src="{{ asset('asset/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>
    <!-- Bootstrap Switch -->
    <!-- BS-Stepper -->
    <!-- AdminLTE for demo purposes -->
    <script src="{{ asset('asset/dist/js/demo.js') }}"></script>
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $('.my-colorpicker1').colorpicker();

            //Initialize Select2 Elements
            $('.select2').select2({
                theme: 'bootstrap4'
            });


            // initialize calendar in all events
            $('#example1 thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#example1 thead');

            var table = $('#example1').DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": true,
                "buttons": ["copy", "excel", "pdf", "colvis"],
                orderCellsTop: true,
                fixedHeader: false,
                "scrollX": true,
                "paging": true,
                initComplete: function() {
                    var api = this.api();

                    // For each column
                    api
                        .columns()
                        .eq(0)
                        .each(function(colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');

                            // On every keypress in this input
                            $('input',
                                    $('.filters th').eq($(api.column(colIdx).header()).index())
                                )
                                .off('keyup change')
                                .on('change', function(e) {
                                    // Get the search value
                                    $(this).attr('title', $(this).val());
                                    var regexr =
                                        '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    // Search the column for that value
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != '' ?
                                            regexr.replace('{search}', '(((' + this.value +
                                                ')))') :
                                            '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();
                                })
                                .on('keyup', function(e) {
                                    e.stopPropagation();

                                    $(this).trigger('change');
                                    $(this).focus()[0].setSelectionRange(cursorPosition,
                                        cursorPosition);
                                });
                        });
                },
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');

        });

        $(function() {
            var url = window.location;
            // for sidebar menu and treeview
            $('ul.nav-treeview a').filter(function() {
                    return this.href == url;
                }).parentsUntil(".nav-sidebar > .nav-treeview")
                .css({
                    'display': 'block'
                })
                .addClass('menu-open').prev('a');
            // .addClass('active');
        });
    </script>
    <script>
        $(document).ready(function() {
            var url = window.location.origin + '/public/doctors';
            var table = $('#doctors').DataTable({
                    'dom': "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'<'float-md-right ml-2'B>f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    'ajax': 'get-doctors',
                    'buttons': ['excel', {
                        'text': '<i class="fa fa-id-badge fa-fw" aria-hidden="true"></i>',
                        'action': function(e, dt, node) {
                            $(dt.table().node()).toggleClass('cards');
                            $('.fa', node).toggleClass(['fa-table', 'fa-id-badge']);
                            dt.draw('page');
                        },
                        'className': 'btn-sm',
                        'attr': {
                            'title': 'Change views',
                        }
                    }],
                    'select': 'single',
                    'columns': [{
                            'orderable': false,
                            'data': null,
                            'className': 'text-center',
                            'render': function(data, type, full, meta) {
                                if (type === 'display') {
                                    var id = data.id;
                                    var image = data.image;
                                    data = '<a href="' + url + '/' + id + '">' +
                                        '<img src="' + image +
                                        '" class="avatar border rounded-circle"></a>';
                                }
                                return data;
                            }
                        },
                        {
                            'data': 'name'
                        },
                        {
                            'data': 'specialty'
                        },
                        {
                            'data': 'email'
                        },
                        {
                            'data': 'phone'
                        },
                        {
                            'data': 'city'
                        },
                        {
                            'data': 'ragion'
                        },
                        {
                            'data': null,
                            'orderable': false,
                            'className': 'text-center',
                            'render': function(data, type, full, meta) {
                                var id = data.id;
                                return `
                        <form method="POST" action="/public/doctors/${id}" style="display:inline;" onsubmit="return confirm('Are you sure to delete this doctor?');">
                            <input type="hidden" name="_token" value="${$('meta[name="csrf-token"]').attr('content')}">
                            <input type="hidden" name="_method" value="DELETE">
                            <button type="submit" class="btn btn-sm btn-danger" title="Delete">
                                <i class="fa fa-trash"></i>
                            </button>
                        </form>
                        
                        <a href="/public/editDoctor/${id}" class="btn btn-warning ml-2" title="Edit">
                            <i class="fa fa-pen"></i>
                        </a>

                        `;
                            }
                        }
                    ],
                    'drawCallback': function(settings) {
                        var api = this.api();
                        var $table = $(api.table().node());

                        if ($table.hasClass('cards')) {
                            var labels = [];
                            $('thead th', $table).each(function() {
                                labels.push($(this).text());
                            });

                            $('tbody tr', $table).each(function() {
                                $(this).find('td').each(function(column) {
                                    $(this).attr('data-label', labels[column]);
                                });
                            });

                            var max = 0;
                            $('tbody tr', $table).each(function() {
                                max = Math.max($(this).height(), max);
                            }).height(max);

                        } else {
                            $('tbody td', $table).each(function() {
                                $(this).removeAttr('data-label');
                            });

                            $('tbody tr', $table).each(function() {
                                $(this).height('auto');
                            });
                        }
                    }
                })
                .on('select', function(e, dt, type, indexes) {
                    var rowData = table.rows(indexes).data().toArray()
                    $('#row-data').html(JSON.stringify(rowData));
                })
                .on('deselect', function() {
                    $('#row-data').empty();
                });
        });

    $(document).ready(function () {
        $('#pending-doctors').DataTable({
            ajax: '{{ route("doctors.pending-list") }}',
            columns: [
                {
                    data: null,
                    orderable: false,
                    className: 'text-center',
                    render: function (data, type, row) {
                        return '<img src="' + (data.image ?? '{{ asset("images/anime3.png") }}') + '" class="avatar border rounded-circle" width="50">';
                    }
                },
                { data: 'name' },
                { data: 'specialty' },
                { data: 'email' },
                { data: 'phone' },
                { data: 'city' },
                { data: 'ragion' },
                {
                    data: null,
                    orderable: false,
                    className: 'text-center',
                    render: function (data) {
                        let csrf = $('meta[name="csrf-token"]').attr('content');
                        return `
                            <a href="/doctors/${data.id}" class="btn btn-sm btn-info" title="View">
                                <i class="fa fa-eye"></i>
                            </a>
                            <form method="POST" action="/public/doctors/${data.id}" style="display:inline;" onsubmit="return confirm('Accept this doctor?');">
                                <input type="hidden" name="_token" value="${csrf}">
                                <input type="hidden" name="_method" value="PUT">
                                <input type="hidden" name="status" value="accept">
                                <button type="submit" class="btn btn-sm btn-success" title="Accept">
                                    <i class="fa fa-check"></i>
                                </button>
                            </form>
                            <form method="POST" action="/public/doctors/${data.id}" style="display:inline;" onsubmit="return confirm('Reject this doctor?');">
                                <input type="hidden" name="_token" value="${csrf}">
                                <input type="hidden" name="_method" value="PUT">
                                <input type="hidden" name="status" value="reject">
                                <button type="submit" class="btn btn-sm btn-danger" title="Reject">
                                    <i class="fa fa-times"></i>
                                </button>
                            </form>
                        `;
                    }
                }
            ]
        });
    });

        $(document).ready(function() {
            var url = window.location.href;
            var table = $('#patients').DataTable({
                    'dom': "<'row'<'col-sm-12 col-md-6'l><'col-sm-12 col-md-6'<'float-md-right ml-2'B>f>>" +
                        "<'row'<'col-sm-12'tr>>" +
                        "<'row'<'col-sm-12 col-md-5'i><'col-sm-12 col-md-7'p>>",
                    'ajax': 'get-patients',
                    'buttons': ['excel', {
                        'text': '<i class="fa fa-id-badge fa-fw" aria-hidden="true"></i>',
                        'action': function(e, dt, node) {

                            $(dt.table().node()).toggleClass('cards');
                            $('.fa', node).toggleClass(['fa-table', 'fa-id-badge']);

                            dt.draw('page');
                        },
                        'className': 'btn-sm',
                        'attr': {
                            'title': 'Change views',
                        }
                    }],
                    'select': 'single',
                    'columns': [{
                            'orderable': false,
                            'data': null,
                            'className': 'text-center',
                            'render': function(data, type, full, meta) {
                                if (type === 'display') {
                                    var id = data.id;
                                    var image = data.image;
                                    data = '<a href="' + url + '/' + id + '"' +
                                        '> <img src=' + image +
                                        ' class="avatar border rounded-circle"></a>';
                                }
                                return data;
                            }
                        },
                        {
                            'data': 'name'
                        },
                        {
                            'data': 'phone',
                        },
                        {
                            'data': 'email',
                        },
                    ],
                    'drawCallback': function(settings) {
                        var api = this.api();
                        var $table = $(api.table().node());

                        if ($table.hasClass('cards')) {

                            // Create an array of labels containing all table headers
                            var labels = [];
                            $('thead th', $table).each(function() {
                                labels.push($(this).text());
                            });

                            // Add data-label attribute to each cell
                            $('tbody tr', $table).each(function() {
                                $(this).find('td').each(function(column) {
                                    $(this).attr('data-label', labels[column]);
                                });
                            });

                            var max = 0;
                            $('tbody tr', $table).each(function() {
                                max = Math.max($(this).height(), max);
                            }).height(max);

                        } else {
                            // Remove data-label attribute from each cell
                            $('tbody td', $table).each(function() {
                                $(this).removeAttr('data-label');
                            });

                            $('tbody tr', $table).each(function() {
                                $(this).height('auto');
                            });
                        }
                    }
                })
                .on('select', function(e, dt, type, indexes) {
                    var rowData = table.rows(indexes).data().toArray()
                    $('#row-data').html(JSON.stringify(rowData));
                })
                .on('deselect', function() {
                    $('#row-data').empty();
                })
        });
    </script>
    @yield('scripts')
</body>

</html>
