@extends ('../welcome')

@section('content')

<body class="hold-transition register-page">
    <div class="register-box">
        <div class="card">
            <div class="card-body register-card-body">
                <p class="login-box-msg">Edit Member</p>

                <form action="{{ route('users.update', $user->id) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="input-group mb-3">
                        <input type="text" name="name" class="form-control" value="{{ old('name', $user->name) }}"
                            placeholder="Full name" required autofocus>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-user"></span>
                            </div>
                        </div>
                    </div>

                    <div class="input-group mb-3">
                        <input type="email" class="form-control" name="email"
                            value="{{ old('email', $user->email) }}" placeholder="Email" required>
                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="userRole">Select User Role</label>
                        <select name="roles[]" class="select2 custom-select form-control-border" multiple="multiple" id="userRole">
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}"
                                    {{ in_array($role->id, $userRoles) ? 'selected' : '' }}>
                                    {{ $role->display_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="userPermissions">Select User Permission</label>
                        <select name="permissions[]" class="select2 custom-select form-control-border" multiple="multiple" id="userPermissions">
                            @foreach ($permissions as $permission)
                                <option value="{{ $permission->id }}"
                                    {{ in_array($permission->id, $userPermissions) ? 'selected' : '' }}>
                                    {{ $permission->display_name }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-6 float-right">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>

                </form>

            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('#userRole').select2({
                placeholder: 'Select Roles',
                allowClear: true
            });

            $('#userPermissions').select2({
                placeholder: 'Select Permissions',
                allowClear: true
            });
        });
    </script>

</body>

@endsection
