@extends ('../welcome')

@section('content')
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h3>Terms and Conditions Management</h3>
        <a href="{{ route('terms.create') }}" class="btn btn-primary">
            <i class="fa fa-plus"></i> Add New Terms
        </a>
    </div>

    @if (session('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ session('success') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            {{ session('error') }}
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    @endif

    <div class="card">
        <div class="card-body">
            <table id="termsTable" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Type</th>
                        <th>Title (EN)</th>
                        <th>Title (AR)</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($terms as $term)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                @if($term->identifier == 'terms')
                                    <span class="badge badge-info">Terms & Conditions</span>
                                @elseif($term->identifier == 'privacy')
                                    <span class="badge badge-warning">Privacy Policy</span>
                                @else
                                    <span class="badge badge-secondary">{{ $term->identifier }}</span>
                                @endif
                            </td>
                            <td>{{ Str::limit($term->title, 50) }}</td>
                            <td>{{ Str::limit($term->title_ar ?? 'N/A', 50) }}</td>
                            <td>
                                @if ($term->is_active)
                                    <span class="badge badge-success">Active</span>
                                @else
                                    <span class="badge badge-secondary">Inactive</span>
                                @endif
                            </td>
                            <td>{{ $term->created_at->format('Y-m-d H:i') }}</td>
                            <td>
                                <a href="{{ route('terms.show', $term->id) }}" class="btn btn-sm btn-info" title="View">
                                    <i class="fa fa-eye"></i>
                                </a>
                                <a href="{{ route('terms.edit', $term->id) }}" class="btn btn-sm btn-primary" title="Edit">
                                    <i class="fa fa-edit"></i>
                                </a>
                                <form action="{{ route('terms.destroy', $term->id) }}" method="POST" class="d-inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete"
                                        onclick="return confirm('Are you sure you want to delete this terms?')">
                                        <i class="fa fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="mt-3">
                {{ $terms->links() }}
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script>
        $(function() {
            $("#termsTable").DataTable({
                "responsive": true,
                "lengthChange": false,
                "autoWidth": false,
                "paging": false,
                "searching": true,
                "ordering": true,
            });
        });
    </script>
@endsection

