@extends ('../welcome')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Create New Terms and Conditions</h3>
        </div>
        <div class="card-body">
            <form action="{{ route('terms.store') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Type *</label>
                            <select name="identifier" class="form-control" required>
                                <option value="terms" {{ old('identifier') == 'terms' ? 'selected' : '' }}>Terms and Conditions</option>
                                <option value="privacy" {{ old('identifier') == 'privacy' ? 'selected' : '' }}>Privacy Policy</option>
                            </select>
                            @error('identifier')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Status</label>
                            <select name="is_active" class="form-control">
                                <option value="1" {{ old('is_active', 1) == 1 ? 'selected' : '' }}>Active</option>
                                <option value="0" {{ old('is_active') == 0 ? 'selected' : '' }}>Inactive</option>
                            </select>
                        </div>
                    </div>
                </div>

                {{-- English Section --}}
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">English Content</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Title (English) *</label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}"
                                placeholder="Terms and Conditions Title" required>
                            @error('title')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Content (English) *</label>
                            <textarea name="body" id="body" class="form-control" rows="10" required>{{ old('body') }}</textarea>
                            @error('body')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                {{-- Arabic Section --}}
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">Arabic Content</h3>
                    </div>
                    <div class="card-body">
                        <div class="form-group">
                            <label>Title (Arabic)</label>
                            <input type="text" name="title_ar" class="form-control" value="{{ old('title_ar') }}"
                                placeholder="عنوان الشروط والأحكام" dir="rtl">
                            @error('title_ar')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>

                        <div class="form-group">
                            <label>Content (Arabic)</label>
                            <textarea name="body_ar" id="body_ar" class="form-control" rows="10" dir="rtl">{{ old('body_ar') }}</textarea>
                            @error('body_ar')
                                <span class="text-danger">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                        <i class="fa fa-save"></i> Create Terms
                    </button>
                    <a href="{{ route('terms.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('scripts')
    <!-- Summernote CSS -->
    <link rel="stylesheet" href="{{ asset('asset/plugins/summernote/summernote-bs4.min.css') }}">
    <!-- Summernote JS -->
    <script src="{{ asset('asset/plugins/summernote/summernote-bs4.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            // Initialize Summernote for English content
            $('#body').summernote({
                height: 300,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });

            // Initialize Summernote for Arabic content
            $('#body_ar').summernote({
                height: 300,
                direction: 'rtl',
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'italic', 'underline', 'clear']],
                    ['fontname', ['fontname']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture', 'video']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
        });
    </script>
@endsection

