@extends ('../welcome')

@section('content')
    <style>
        .ribbon.red {
            background-color: #bc1a3a;
            background-image: -webkit-linear-gradient(top, #a61733 45%, #bc1a3a 100%);
            background-image: -o-linear-gradient(top, #a61733 45%, #bc1a3a 100%);
            background-image: linear-gradient(to bottom, #a61733 45%, #bc1a3a 100%);
            background-repeat: repeat-x;
            filter: progid: DXImageTransform.Microsoft.gradient(startColorstr='#ffa61733', endColorstr='#ffbc1a3a', GradientType=0)
        }

        .ribbon.green {
            background-color: #2da285;
            background-image: -webkit-linear-gradient(top, #2da285 45%, #227a64 100%);
            background-image: -o-linear-gradient(top, #2da285 45%, #227a64 100%);
            background-image: linear-gradient(to bottom, #2da285 45%, #227a64 100%);
            background-repeat: repeat-x;
            filter: progid: DXImageTransform.Microsoft.gradient(startColorstr='#ff2da285', endColorstr='#ff227a64', GradientType=0)
        }
    </style>

    <div class="card col-6">
        <div class="card-header">
            <div class="ribbon-wrapper">
                <div class="ribbon {{ $slider->is_active == 0 ? 'red' : 'green' }}"
                    title="{{ $slider->is_active == 0 ? 'Not Active' : 'Active' }}"></div>
            </div>
            <img class="img-fluid" style="text-align:center" src="{{ URL::to('/') }}/images/{{ $slider->image }}"
                alt="{{ URL::to('/') }}/images/' . $slider->image) }}">
        </div>
        <div class="card-body">
            <div class=" row">
                <label class="col-sm-4 col-form-label">English Description :</label>
                <label class="col-sm-8 col-form-label">{{ $slider->description_en ?? '' }} </label>
            </div>

            <div class=" row">
                <label class="col-sm-4 col-form-label">Arabic Description :</label>
                <label class="col-sm-8 col-form-label">{{ $slider->description_ar ?? '' }} </label>
            </div>
        </div>
        <div class="card-footer">
            <div style="float:right">
                <a class="btn btn-info" title="Edit" href="{{ route('sliders.edit', $slider->id) }}">
                    Edit
                </a>
                <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                    data-id="{{ $slider->id }}" data-toggle="modal" data-target="#exampleModalCenter">
                    Delete
                </button>
            </div>
        </div>


        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Record</h5>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure to delete this record ?</p>
                    </div>
                    <form class="modal-footer" method="post">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('sliders.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
