@extends ('../welcome')


@section('content')

    <body class="hold-transition register-page">
        <div class="col-8">
            <div class="card">
                <div class="card-body register-card-body">
                    <p class="login-box-msg">Edit Hospital</p>

                    <form action="{{ route('hospitals.update', $hospital->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <input type="text" name="name" class="form-control" placeholder="Name"
                                        value="{{ $hospital->name }}" required autofocus>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-user"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <input type="text" name="address" class="form-control" placeholder="Address"
                                        value="{{ $hospital->address }}" required autofocus>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-home"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <input type="tel" name="phone" class="form-control" placeholder="Phone"
                                        value="{{ $hospital->phone }}" required autofocus>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-phone"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <label for="timeTo">From</label>
                                    <input type="time" id="timeTo" name="from" class="form-control p-1"
                                        placeholder="Time From" value="{{ $hospital->from }}" required autofocus>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-clock"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group mb-3">
                                    <label for="timeFrom">To</label>
                                    <input type="time" id="timeFrom" name="to" class="form-control p-1"
                                        placeholder="Time to" value="{{ $hospital->to }}" required autofocus>
                                    <div class="input-group-append">
                                        <div class="input-group-text">
                                            <span class="fas fa-clock"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="input-group-text mb-3">
                                    <textarea name="description" id="description" cols="30" rows="8" class="form-control">{{ $hospital->description }}</textarea>
                                </div>
                            </div>
                            
                            @if ($hospital->getFirstMediaUrl($hospital->id))
                                <div class="mb-3">
                                    <label>Current Image:</label><br>
                                    <img src="{{ $hospital->getFirstMediaUrl($hospital->id) }}" alt="Hospital Image" width="200">
                                </div>
                            @endif
                            
                            <div class="col-12">
                                <label>Upload New Image (optional):</label>
                                <input type="file" name="image" class="form-control">
                            </div>

                            
                             <hr>
                        <div class="d-flex" style="flex-direction: column;">
                            <h5 class="mt-4">Assigned Doctors</h5>
                             @foreach ($hospital->doctors as $doctor)
                                <div class="doctor-times border p-2 mb-2">
                                    <input type="hidden" name="assignedDoctors[{{ $loop->index }}][doctor_id]" value="{{ $doctor->id }}">
                            
                                    <label>Doctor: {{ $doctor->name }}</label>
                            
                                    <div>
                                        <label>AM From:</label>
                                        <input type="time" name="assignedDoctors[{{ $loop->index }}][am_from]" value="{{ json_decode($doctor->pivot->am)->from }}">
                                        <label>AM To:</label>
                                        <input type="time" name="assignedDoctors[{{ $loop->index }}][am_to]" value="{{ json_decode($doctor->pivot->am)->to }}">
                                    </div>
                            
                                    <div>
                                        <label>PM From:</label>
                                        <input type="time" name="assignedDoctors[{{ $loop->index }}][pm_from]" value="{{ json_decode($doctor->pivot->pm)->from }}">
                                        <label>PM To:</label>
                                        <input type="time" name="assignedDoctors[{{ $loop->index }}][pm_to]" value="{{ json_decode($doctor->pivot->pm)->to }}">
                                    </div>
                                </div>
                            @endforeach

                        </div>

                        </div>

                        <div class="col-12 text-center">
                            <button type="submit" class="btn btn-primary">Edit Hospital</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <!-- /.form-box -->
        <!-- /.card -->
        <!-- /.register-box -->
    </body>
@endsection
