@extends ('../welcome')

@section('content')
    <style>
        .img-fluid {
            max-width: 24%;
        }
    </style>
    

    <div class="card-body">

        <div class=" row">
            <label class="col-sm-2 col-form-label">Name :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->name }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">phone :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->phone }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">email :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->email }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">gender :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->gender }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">job_title :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->job_title }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">summary :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->summary }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">state :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->state }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">city :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->city }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">ragion :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->ragion }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Secretary Number :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->secretary_number ?? 'N/A' }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Price :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->price ? number_format($doctor->price, 2) . ' EGP' : 'N/A' }} </label>
        </div>
        <div class=" row">
            <label class="col-sm-2 col-form-label">Total Rate :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->total_rate ?? '0' }} </label>
        </div>

        <div class=" row">
            <label class="col-sm-2 col-form-label">Doctor Image :</label>
            <a href="{{ URL::to('/') }}/images/{{ $doctor->image }}">
                <img src="{{ $doctor->getFirstMediaUrl($doctor->phone) ? $doctor->getFirstMediaUrl($doctor->phone) : asset('images/anime3.png') }}" width="120px">
            </a>
        </div>
        
@php use Illuminate\Support\Str; @endphp

@php
    $certificates = $doctor->getMedia($doctor->phone)->filter(function ($file) {
        return !Str::startsWith($file->mime_type, 'image/');
    });
@endphp

@if($certificates->count() > 0)
    <div class="row mt-4">
        <div class="col-12">
            <h5 class="mb-3">Doctor Certificates</h5>
            <div class="card">
                <div class="card-header">
                    <span>Certificates ({{ $certificates->count() }})</span>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Certificate Name</th>
                                    <th>File Type</th>
                                    <th>Upload Date</th>
                                    <th>Size</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($certificates as $file)
                                    <tr>
                                        <td>{{ $file->name }}</td>
                                        <td>
                                            <span class="badge badge-info">{{ $file->mime_type ?? 'Unknown' }}</span>
                                        </td>
                                        <td>{{ $file->created_at ? $file->created_at->format('Y-m-d H:i') : 'N/A' }}</td>
                                        <td>{{ $file->size ? number_format($file->size / 1024, 2) . ' KB' : 'N/A' }}</td>
                                        <td>
                                            <a href="{{ $file->getFullUrl() }}" download class="btn btn-sm btn-outline-primary" title="Download Certificate">
                                                <i class="fa fa-download"></i> Download
                                            </a>
                                            <a href="{{ $file->getFullUrl() }}" target="_blank" class="btn btn-sm btn-outline-info" title="View Certificate">
                                                <i class="fa fa-eye"></i> View
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif




        <div class=" row">
            <label class="col-sm-2 col-form-label">Speciality :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->specialty->name_en ?? '' }} -
                {{ $doctor->specialty->name_ar ?? '' }}
            </label>
        </div>

        @if($doctor->clinics && $doctor->clinics->count() > 0)
            <div class="row mt-3">
                <label class="col-sm-2 col-form-label">Clinics :</label>
                <div class="col-sm-10">
                    @foreach($doctor->clinics as $clinic)
                        <div class="card mb-2">
                            <div class="card-body">
                                <h6 class="card-title">{{ $clinic->name }}</h6>
                                <p class="card-text mb-1">
                                    <strong>Address:</strong> {{ $clinic->address ?? 'N/A' }}<br>
                                    <strong>Phone:</strong> {{ $clinic->phone ?? 'N/A' }}
                                </p>
                                @php
                                    $am = json_decode($clinic->pivot->am, true);
                                    $pm = json_decode($clinic->pivot->pm, true);
                                @endphp
                                <p class="card-text mb-0">
                                    <strong>AM Schedule:</strong> {{ $am['from'] ?? 'N/A' }} - {{ $am['to'] ?? 'N/A' }}<br>
                                    <strong>PM Schedule:</strong> {{ $pm['from'] ?? 'N/A' }} - {{ $pm['to'] ?? 'N/A' }}
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
        @foreach ($doctor->files as $file)
            <img class="img-fluid" src="{{ URL::to('/') }}/files/{{ $file->name }}"
                alt="{{ URL::to('/') }}/files/{{ $file->name }}">
        @endforeach

        <div class=" row">
            <label class="col-sm-2 col-form-label">Confirmation :</label>
            <label class="col-sm-4 col-form-label">{{ $doctor->status }} </label>
        </div>
        <div class="row">
            @if ($doctor->status == 'pending')
                &nbsp;&nbsp;
                <form action="{{ route('doctors.update', $doctor->id) }}" method="post">
                    @csrf
                    @method('PUT')
                    <input type='hidden' name="status" value='accept'>
                    <button type="submit" class="btn btn-success" title="Accept">
                        <i class="fa fa-check"></i>
                    </button>
                </form>
                &nbsp;&nbsp;
                <form action="{{ route('doctors.update', $doctor->id) }}" method="post">
                    @csrf
                    @method('PUT')
                    <input type='hidden' name="status" value='reject'>
                    <button type="submit" class="btn btn-danger" title="Reject">
                        <i class="fa fa-trash"></i>
                    </button>
                </form>
            @endif
        </div>
    </div>

    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Reject Doctor</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure you want to Reject this Doctor ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('doctors.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
