@extends ('../welcome')

@section('content')
<div class="card">
    <div class="card-body register-card-body mt-5 ml-4">
        <form action="{{ route('doctors.store') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                {{-- Left Column --}}
                <div class="col-6">
                    <div class="form-group">
                        <label>Name *</label>
                        <input type="text" name="name" class="form-control" placeholder="Name" required>
                    </div>

                    <div class="form-group">
                        <label>Phone *</label>
                        <input type="tel" name="phone" class="form-control" placeholder="Phone" required>
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email" class="form-control" placeholder="email@example.com">
                    </div>

                    <div class="form-group">
                        <label>Password (optional)</label>
                        <input type="password" name="password" class="form-control" placeholder="Password">
                    </div>

                    <div class="form-group">
                        <label>State</label>
                        <input type="text" name="state" class="form-control" placeholder="State">
                    </div>

                    <div class="form-group">
                        <label>City</label>
                        <input type="text" name="city" class="form-control" placeholder="City">
                    </div>

                    <div class="form-group">
                        <label>Ragion</label>
                        <input type="text" name="ragion" class="form-control" placeholder="Ragion">
                    </div>

                </div>

                {{-- Right Column --}}
                <div class="col-6">
                    <div class="form-group">
                        <label>Summary</label>
                        <textarea name="summary" class="form-control" placeholder="Short summary"></textarea>
                    </div>

                    <div class="form-group">
                        <label>Gender</label>
                        <select name="gender" class="form-control">
                            <option value="">Select Gender</option>
                            <option value="male">Male</option>
                            <option value="female">Female</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Job Title</label>
                        <input type="text" name="job_title" class="form-control" placeholder="Job Title">
                    </div>

                    <div class="form-group">
                        <label>Specialty</label>
                        <select name="specialty_id" class="form-control">
                            <option value="">Select Specialty</option>
                            @foreach (\App\Models\Speciality::all() as $speciality)
                                <option value="{{ $speciality->id }}">{{ $speciality->name_en }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Secretary Number</label>
                        <input type="text" name="secretary_number" class="form-control" placeholder="Secretary Number">
                    </div>

                    <div class="form-group">
                        <label>Profile Image</label>
                        <input type="file" name="image" class="form-control-file">
                    </div>

                    <div class="form-group">
                        <label>Attachment Files</label>
                        <input type="file" name="files" class="form-control-file">
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary w-100">Create Doctor</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
