@extends ('../welcome')


@section('content')

    <body class="hold-transition register-page">
        <div class="register-box">
            <div class="card">
                <div class="card-body register-card-body">
                    <p class="login-box-msg">Add New Clinic</p>

                    <form action="{{ route('clinicsAssign.store') }}" method="POST">
                        @csrf
                        <div class="row">
                            <label for="doctorSearch">Select Doctor:</label>
                            <select name="doctor" id="doctorSearch" class="form-control">
                                <option value=""></option>
                                @foreach ($doctors as $doctor)
                                    <option value="{{ $doctor->id }}">{{ $doctor->name }}</option>
                                @endforeach
                            </select>

                            <label class="my-3" for="clinicSearch">Select Clinic:</label>
                            <select id="clinicSearch" name="clinic" class="form-control">
                                <option value=""></option>
                                @foreach ($clinics as $clinic)
                                    <option value="{{ $clinic->id }}">{{ $clinic->name }}</option>
                                @endforeach
                            </select>

                            <div class="col-12 my-2">
                                <label for="">Am</label>
                                <div class="row">
                                    <div class="col-6 input-group mb-3">
                                        <label for="timeAmFrom">From</label>
                                        <input type="time" id="timeAmFrom" name="amfrom" class="form-control"
                                            placeholder="Open Hours" required autofocus>
                                    </div>

                                    <div class="col-6 input-group mb-3">
                                        <label for="timeAmTo">To</label>
                                        <input type="time" id="timeAmTo" name="amTo" class="form-control"
                                            placeholder="Open Hours" required autofocus>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 my-2">
                                <label for="">Pm</label>
                                <div class="row">
                                    <div class="col-6 input-group mb-3">
                                        <label for="timePmFrom">From</label>
                                        <input type="time" id="timePmFrom" name="pmFrom" class="form-control"
                                            placeholder="Open Hours" required autofocus>
                                    </div>

                                    <div class="col-6 input-group mb-3">
                                        <label for="timePmTo">To</label>
                                        <input type="time" id="timePmTo" name="pmTo" class="form-control"
                                            placeholder="Open Hours" required autofocus>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-primary">Add Clinic</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- /.form-box -->
        </div><!-- /.card -->
        <!-- /.register-box -->
    </body>

    <script>
        $(document).ready(function() {
            $('#doctorSearch').select2({
                placeholder: 'Select a Doctor',
                allowClear: true,
            });
        });

        $(document).ready(function() {
            $('#clinicSearch').select2({
                placeholder: 'Select a Clinic',
                allowClear: true,
            });
        });
    </script>
@endsection
