<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TermsAndCondition extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'terms_and_conditions';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'identifier',
        'title',
        'body',
        'title_ar',
        'body_ar',
        'is_active',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'is_active' => 'boolean',
    ];

    /**
     * Get the title based on the current locale.
     */
    public function getLocalizedTitleAttribute(): string
    {
        $locale = app()->getLocale();
        return $locale === 'ar' && $this->title_ar ? $this->title_ar : $this->title;
    }

    /**
     * Get the body based on the current locale.
     */
    public function getLocalizedBodyAttribute(): string
    {
        $locale = app()->getLocale();
        return $locale === 'ar' && $this->body_ar ? $this->body_ar : $this->body;
    }

    /**
     * Get the active terms and conditions or privacy policy
     * 
     * @param string $identifier 'terms' or 'privacy'
     * @return TermsAndCondition|null
     */
    public static function getActiveTerms($identifier = 'terms')
    {
        return self::where('identifier', $identifier)
            ->where('is_active', true)
            ->latest()
            ->first();
    }
}

