<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HospitalSpeciality extends Model
{
    use HasFactory;

    protected $table = 'hospital_specialty';

    protected $fillable = [
        'hospital_id',
        'specialty_id',
    ];

    public function hospital()
    {
        return $this->belongsTo(Hospital::class, 'hospital_id');
    }

    public function speciality()
    {
        return $this->belongsToMany(Speciality::class, 'speciality_id');
    }
}
