<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class PatientResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');

        $image = $this->getMedia($this->phone)->first(function ($media) {
            // Filter for images (e.g., JPEG, PNG, GIF, etc.)
            return strstr($media->mime_type, 'image/') !== false;
        });

        return [
            'id' => $this->id,
            'name' => $this->name,
            'image' => $image ? $image->getUrl() : asset('images/patient.jpg'),
            'phone' => $this->phone,
            'email' => $this->email,
            'gender' => $this->gender,
            'address' => $this->address,

        ];
    }
}
