<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class HospitalResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $specialities = [];

        foreach ($this->speciality as $speciality) {
            array_push($specialities, [
                'name_en' => $speciality->name_en,
                'name_ar' => $speciality->name_ar,
            ]);
        }

        $image = $this->getMedia($this->id)->first(function ($media) {
            // Filter for images (e.g., JPEG, PNG, GIF, etc.)
            return strstr($media->mime_type, 'image/') !== false;
        });

        return
            [
                'id' => $this->id,
                'name' => $this->name,
                'address' => $this->address,
                'description' => $this->description,
                'phone' => $this->phone,
                'rate' => $this->rate,
                'from' => $this->from,
                'to' => $this->to,
                'whatsapp_number' => $this->whatsapp_number,
                'image'=> $image ? $image->getUrl() : asset('images/hospital.jpg'),
                'specialities' => $specialities,
            ];
    }
}
