<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Http\Resources\Json\Resource;
use App;

class DoctorResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $lang = $request->header('lang');
        $image = $this->getMedia($this->phone)->first(function ($media) {
            // Filter for images (e.g., JPEG, PNG, GIF, etc.)
            return strstr($media->mime_type, 'image/') !== false;
        });
        
        return [
            'id' => $this->id,
            'name' => $this->name,
            'image' => $image ? $image->getUrl() : asset('images/anime3.png'),
            'specialty' => $lang == 'ar' ? $this->specialty->name_ar ?? '' : $this->specialty->name_en ?? '',
            'phone' => $this->phone,
            'email' => $this->email,
            'gender' => $this->gender,
            'job_title' => $this->job_title,
            'price' => $this->price,
            'summary' => $this->summary,
            'state' => $this->state,
            'city' => $this->city,
            'ragion' => $this->ragion,
            'secretary_number' => $this->secretary_number,
        ];
    }
}
