<?php

namespace App\Http\Controllers;

use App\Models\Slider;
use Illuminate\Http\Request;

class SliderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $sliders = Slider::get();
        return view('sliders.index', compact('sliders'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view('sliders.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $slider = new Slider();
        $slider->description_ar = $request->description_ar;
        $slider->description_en = $request->description_en;

        if($request->hasFile('image')){
            $slider->image = $request['image']->getClientOriginalName();
            // $imageName = $request->image .'.'.$request->image->extension();
            $request->image->move(public_path('images'), $slider->image);
        }

        $slider->save();

        return redirect()->route('sliders.index')
                        ->with('success','slider created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function show(Slider $slider)
    {
        //
        return view('sliders.show', compact('slider'));

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function edit(Slider $slider)
    {
        //
        return view('sliders.edit', compact('slider'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Slider $slider)
    {
        $slider->description_ar = $request->description_ar;
        $slider->description_en = $request->description_en;

        if($request->hasFile('image')){
            $slider->image = $request['image']->getClientOriginalName();
            // $imageName = $request->image .'.'.$request->image->extension();
            $request->image->move(public_path('images'), $slider->image);
        }

        $slider->save();

        return redirect()->route('sliders.show', $slider->id)
                        ->with('success','slider updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Slider  $slider
     * @return \Illuminate\Http\Response
     */
    public function destroy(Slider $slider)
    {
        //
        $slider->delete();
        return redirect()->route('sliders.index')
                        ->with('success','slider deleted successfully');
    }

    
    public function hideSlider($id)
    {
        $slider = Slider::find($id);
        if($slider->is_active == 0){
            $slider->is_active = 1;
        }else{
            $slider->is_active = 0;
        }
        $slider->save();
        if($slider->is_active == 0){
            return redirect()->back()
                            ->with('success','slider De-activated successfully');
        }else{
            return redirect()->back()
                            ->with('success','slider Activated successfully');

        }
    }
}
