<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ServiceController extends Controller
{
    //

    public function index(){
        $services = Service::get();
        return view('services.index',compact('services'));
    }

    public function create(){
        return view('services.create');
    }

    public function store(Request $request){
        try{
            Service::create([
                'name'=>$request->name,
                'description' => $request->description
        ]);
            return redirect()->route('services.index')->with('success' , 'Service Created Successfully');
        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }

    public function edit(Request $request){
        $service = Service::findOrFail($request->id);
        return view('services.edit' , compact('service'));
    }

    public function update(Request $request){
        $service_id = $request->id;
        $service = Service::findorFail($service_id);
        try{

            $service->update($request->all());

            return redirect()->route('services.index')->with('success','Service Updated Successfully');
        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }

    public function delete(Request $request){
        try{
            $service_id = $request->id;
            $service = Service::findorFail($service_id);
            $service->delete();

            return redirect()->route('services.index')->with('success','Service Deleted Successfully');

        }catch(Exception $ex){
            return redirect()->back()->with('error' , $ex->getMessage());
        }
    }
}
