<?php

namespace App\Http\Controllers;

use App\Models\Patient;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Resources\PatientResource;

class PatientController extends Controller
{

    public function index()
    {
        $patients = Patient::get();
        return view('patients.index', compact('patients'));
    }

    public function getPatients()
    {
        try{
            $patients = Patient::get();
            $data = PatientResource::collection($patients);

            return response()->json([
                'statusCode' => 200,
                'data' => $data
            ]);
        }catch(Exception $e){
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function show(Patient $patient)
    {
        return view('patients.show', compact('patient'));
    }

    public function edit(Patient $patient){
        try{

         $patient_id = $patient->id;
         if (!$patient_id || !Patient::find($patient_id)) {
             return redirect()->back()->with('error','invalid patient id');
         }
         $patient = Patient::find($patient_id);
         return view('patients.edit',compact('patient'));

        }catch(Exception $ex){
         return redirect()->back()->with('error',$ex->getMessage());
        }
     }

     public function update(Request $request){
        $patient_id = $request->id;
        $patient = Patient::findorFail($patient_id);
        try
        {
            DB::beginTransaction();
            $patient->update($request->all());
            DB::commit();
            return redirect()->route('patients.show', $request->id)->with('success','Patient Updated Successfully');

        }
        catch(Exception $e){
            return redirect()->back()->with('error',$e->getMessage());
        }
     }
    
    
     public function changeStatus(Request $request){
        $patient = Patient::findOrFail($request->id);
        $patient->confirmed = 1;
        $patient->save();
        return redirect()->route('patients.index')
                        ->with('success','patient confirmed successfully');
    }

}
