<?php

namespace App\Http\Controllers;

use App\Models\Clinic;
use App\Models\ClinicDoctor;
use App\Models\Doctor;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Redis;

class ClinicsController extends Controller
{

    public function index()
    {
        $clinics = Clinic::get();
        return view('clinics.index', compact('clinics'));
    }

    public function create()
    {
        return view('clinics.create');
    }

    public function show(Request $request)
    {
        try {
            $clinic = Clinic::findOrFail($request->id);
            return view('clinics.show', compact('clinic'));
        } catch (Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage());
        }
    }

    public function store(Request $request)
    {
        try {

            Clinic::create([
                'name' => $request->name,
                'description' => $request->description,
                'phone' => $request->phone,
                'address' => $request->address,
                'created_by' => auth()->user()->id,
            ]);
            return redirect()->route('clinics.index')->with('success', 'Clinic Created Successfully');
        } catch (Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage());
        }
    }

    public function edit(Request $request)
    {
        $clinic = Clinic::findOrFail($request->id);
        return view('clinics.edit', compact('clinic'));
    }

    public function update(Request $request)
    {
        $clinic_id = $request->id;
        $clinic = Clinic::findorFail($clinic_id);
        try {
            $clinic->update($request->all());

            return redirect()->route('clinics.index')->with('success', 'Clinic Updated Successfully');
        } catch (Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage());
        }
    }

    public function delete(Request $request)
    {
        try {
            $clinic_id = $request->id;
            $clinic = Clinic::findorFail($clinic_id);
            $clinic->delete();

            return redirect()->route('clinics.index')->with('success', 'Clinic Deleted Successfully');
        } catch (Exception $ex) {
            return redirect()->back()->with('error', $ex->getMessage());
        }
    }

    public function assign()
    {
        $doctors = Doctor::get();
        $clinics = Clinic::get();

        return view('clinics.assign', compact('doctors', 'clinics'));
    }

    public function assignStore(Request $request)
    {

        $doctorId = $request->input('doctor');
        $clinicId = $request->input('clinic');

        $am = json_encode([
            'from' => $request->amfrom,
            'to' => $request->amTo
        ]);

        $pm = json_encode([
            'from' => $request->pmFrom,
            'to' => $request->pmTo
        ]);

        ClinicDoctor::create([
            'doctor_id' => $doctorId,
            'clinic_id' => $clinicId,
            'am' => $am,
            'pm' => $pm,
        ]);

        $clinics = Clinic::get();
        return view('clinics.index', compact('clinics'));
    }
}
