<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Speciality;
use App\Http\Resources\SpecialityResource;
use Illuminate\Http\Request;
use App;
use App\Models\Doctor;
use Exception;

class SpcialityController extends Controller
{
    public function index(Request $request)
    {
        try{
            $lang = $request->header('lang');
            $specialities = Speciality::get();
    
            $data = SpecialityResource::collection($specialities);

               return response()->json([
                'statusCode' => 200,
                'data' =>$data,
            ]);
    
        }catch(Exception $e){
            return response()->json([
                'statusCode' => 500,
                'message'=> $e->getMessage(),
            ]);
        }
    }

}
