<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Patient;
use App\Models\User;
use Exception;
use App\Http\Resources\PatientResource;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class PatientController extends Controller
{
    public function index(Request $request)
    {
        try {
            $lang = $request->header('lang');
            $patients = Patient::get();
            $data = PatientResource::collection($patients);

            return response()->json([
                'statusCode' => 200,
                'data' => $data
            ]);
        } catch (Exception $e) {
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function show(Request $request)
    {
        try {
            $lang = $request->header('lang');

            $patient = Patient::find($request->id);
            if (!$patient) {
                return response()->json([
                    'statusCode' => 404,
                    'message' => $lang == 'en' ? 'Invalid patient Id ' : 'رقم المريض غير معرف',
                ]);
            }
            $data = new PatientResource($patient);
            return response()->json([
                'statusCode' => 200,
                'data' => $data,
            ]);
        } catch (Exception $e) {
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function update(Request $request)
    {
        try {
            $lang = $request->header('lang');

            if ($request->type == 'patient') {
                $patient = Patient::find($request->id);
                if (!$request->id || !$patient) {
                    return response()->json([
                        'statusCode' => 404,
                        'message' => $lang == 'en' ? 'Invalid Doctor Id ' : 'رقم الدكتور غير معرف',

                    ]);
                }


                // Remove existing media (profile picture) if any
                $patient->clearMediaCollection($patient->phone);

                // Upload and associate the new profile picture
                $patient->addMediaFromRequest('image')
                    ->toMediaCollection($patient->phone);

                $patient->update($request->except(['type', 'image']));

                return response()->json([
                    'statusCode' => 200,
                    'message' => $lang == 'en' ? 'your profile Updated Successfully' : 'تم تعديل بياناتك  بنجاح',
                ]);
            }
        } catch (Exception $e) {
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }

    public function patientImage(Request $request)
    {
        $lang = $request->header('lang');

        try {
            $patient = Patient::find($request->id);

            // Remove existing media (profile picture) if any
            $patient->clearMediaCollection($patient->phone);

            // Upload and associate the new profile picture
            $patient->addMediaFromRequest('image')
                ->toMediaCollection($patient->phone);

            $image = $patient->getMedia($patient->phone)->first(function ($media) {
                // Filter for images (e.g., JPEG, PNG, GIF, etc.)
                return strstr($media->mime_type, 'image/') !== false;
            });

            return response([
                'statusCode' => 200,
                'message' => $lang == 'ar' ? 'تم تغيير الصورة بنجاح' : 'image uploaded successfully',
                'data' => [
                    'image' => $image,
                ]
            ]);
        } catch (Exception $e) {
            return response([
                'statusCode' => 422,
                'message' => $lang == 'ar' ? 'لم يتم تغيير الصورة' : 'Failed to uploade image',
                'data' => ['message' => $e->getMessage()]
            ]);
        }
    }

    public function destroy(Request $request)
    {
        try {
            $lang = $request->header('lang');
            $patient = Patient::find($request->id);
            $patient->delete();

            return response()->json([
                'statusCode' => 500,
                'message' => $lang == 'en' ? 'patient has been Deleted Successfully' : 'تم حذف بيانات الدكتور بنجاح',
            ]);
        } catch (Exception $e) {
            return response()->json([
                'statusCode' => 500,
                'message' => $e->getMessage(),
            ]);
        }
    }
}
