


<?php $__env->startSection('content'); ?>
    <div class="card-outline-light col-6">
        <div class="card-header">
            <h3 class="card-title">Unit Reservation for Client:
                <a href="<?php echo e(route('clients.show', $client->id)); ?>"><?php echo e($client->name); ?></a>
            </h3>

            <?php if(!empty($unit)): ?>
                <?php if($unit->status == 'reserved' || 'hold'): ?>
                    <form action="<?php echo e(route('reservationContract')); ?>" method="post">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="unit_id" value="<?php echo e($unit->id); ?>">
                        <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                        <button type="submit" class="btn btn-success" title="Reservation Form" style="float:right"><i
                                class="fas fa-file-alt"></i></button>
                    </form>
                <?php endif; ?>
            <?php endif; ?>
        </div>
        <div class="card-body">
            <!-- UnitFree -->
            <?php if($unit == ''): ?>
                <div class="unitFree">
                    <form method="post" action="<?php echo e(route('AssignUnit', $client->id)); ?>">
                        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">
                        <div class="form-group">
                            <label for="project_id">Select Project</label>
                            <select name="project_id" id="projects" class="custom-select form-control-border">
                                <option></option>
                                <?php $__currentLoopData = $projects; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $project): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($project->id); ?>"><?php echo e($project->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="row" style="margin-left:5px;">
                            <div class="form-group col-4">

                                <label for="unit_id">Choose unit</label>
                                <select name="unit_id" id="units" class="select2 custom-select form-control-border">

                                </select>

                            </div>

                            <div class="form-group col-6">
                                <label for="payment_plan" style="margin-left:20px;">Select Payment Plan</label>
                                <select name="payment_plan" id="payment_plans" style="margin-left:20px;"
                                    class="custom-select form-control-border">
                                </select>
                            </div>

                            <div class="form-group col-4">
                                <label for="status" style="margin-left:20px;">status</label>
                                <select name="status" style="margin-left:20px;" id="status"
                                    class="custom-select form-control-border">
                                    <option value="hold">hold</option>
                                    <option value="reserved">reserved</option>
                                    <option value="downpayment">downpayment</option>
                                </select>
                            </div>

                            <div class="form-group col-4 mx-3" id="reservation-amount" style="display:none;">
                                <label for="reservation" class="form-group">Reservation
                                    Amount</label>
                                <input name="reservation" class="form-control" type="number" step="any">
                            </div>

                            <div class="form-group col-4 mx-3" id="downpayment-amount" style="display:none;">
                                <label for="downpayment" class="form-group">Downpayment
                                    Amount</label>
                                <div class="form-group">
                                    <input name="down_payment" class="form-control" type="number">
                                </div>
                            </div>
                        </div>
                        <label for="facilities" style="margin-left:20px;">Has Facilities ?</label>
                        <div id="facilities" style="margin-left:20px;">

                        </div>

                        
                        <br>
                        <div class="row" style=" margin-top:70px;margin-left:20%">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>
                    </form>
                </div>
            <?php endif; ?>
            <!-- With Unit -->
            <?php if(!empty($unit)): ?>
                <div class="WithUnit">
                    <form method="post" action="<?php echo e(route('AssignUnit', $client->id)); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="client_id" value="<?php echo e($client->id); ?>">

                        <div class="form-group">
                            <label for="project_id">project</label>
                            <input type="text" disabled class="form-control"
                                value="<?php echo e($unit->building?->phase?->project?->name); ?>">
                            <input type="hidden" name="project_id" class="form-control"
                                value="<?php echo e($unit->building?->phase?->project?->id); ?>">
                        </div>
                        <div class="row" style="margin-left:5px;">
                            <div class="form-group">
                                <label>unit</label>
                                <input class="form-control" disabled value="<?php echo e($unit->name); ?>">
                                <input type="hidden" name="unit_id" class="form-control" value="<?php echo e($unit->id); ?>">

                            </div>

                            <div class="form-group">
                                <label for="status" style="margin-left:20px;">status</label>
                                <select name="status" style="margin-left:20px;" id="status"
                                    class="custom-select form-control-border">
                                    <?php if($unit->status == 'hold'): ?>
                                        <option value="reserved">reserved</option>
                                        <option value="downpayment">downpayment</option>
                                    <?php elseif($unit->status == 'reserved'): ?>
                                        <option value="downpayment">downpayment</option>
                                    <?php elseif($unit->status == 'downpayment'): ?>
                                        <option value="downpayment">downpayment</option>
                                    <?php else: ?>
                                        <option value="hold">hold</option>
                                        <option value="reserved">reserved</option>
                                        <option value="downpayment">downpayment</option>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <?php if(count($facilities) != 0): ?>
                            <label for="facilities" style="margin-left:20px;">Facilities </label>

                            <?php for($i = 0; $i < count($facilities); $i++): ?>
                                <li>
                                    <?php echo e($facilities[$i]['name']); ?> - <?php echo e($facilities[$i]['price']); ?> -
                                    <?php echo e($facilities[$i]['price_word']); ?>

                                </li>
                            <?php endfor; ?>
                        <?php endif; ?>
                        <br>

                        <label for="reservation">Reservation Amount</label>
                        <div id="reservation" class="form-group">
                            <input name="reservation" class="form-control" value="<?php echo e($payment->reservation ?? ''); ?>"
                                type="number" step="any">
                        </div>

                        <label for="reservation">DownPayment Amount</label>
                        <div class="form-group">
                            <input name="down_payment" title="total downpayment = reservation amount + down payment"
                                class="form-control" value="<?php echo e($payment->down_payment ?? ''); ?>" type="number"
                                step="any">
                        </div>

                        <button style="float:right" type="submit" class="btn btn-info">Submit</button>
                    </form>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!--  -->
    <script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="//cdn.ckeditor.com/4.14.1/standard/ckeditor.js"></script>
    <script type="text/javascript">
        $(document).on('change', '#projects', function() {
            var data = this.value;

            $.ajax({
                data: {
                    'project_id': data
                },
                method: "POST",
                url: "<?php echo e(route('unitReservation')); ?>",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    let facilities = "";
                    let units = "";
                    Array.from(dataResult.facilities).forEach(myFunction);

                    function myFunction(item, index) {
                        facilities += `
                <div id="inputFormRow">

                    <div class="row">
                            <div class="form-check">
                                <input class="form-check-input " id="facility" name="facility_id[]" value="` + item
                            .id + `"
                                    type="checkbox">
                                <label class="form-check-label">` + item.name + `</label>

                            </div>
                            <div class="form-group">
                                <input class="form-control" name="facility_price[]" id="facility_price" 
                                    type="number" step="any" placeholder="00" disabled>
                            </div>
                                
                            <div class="form-group">
                                <input class="form-control" name="facility_price_word[]" id="facility_price" 
                                    type="text" placeholder="صفر جنيه" disabled>
                            </div>
                            </div>
                    </div>`;
                    }
                    document.getElementById("facilities").innerHTML = facilities;


                    Array.from(dataResult.units).forEach(myFunction2);

                    function myFunction2(item, index) {
                        units += `
                        <option value=""></option>
                        <option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("units").innerHTML = units;
                }
            });
        });

        $(document).on('change', '#facility', function() {
            if ($(this).closest('#inputFormRow').find("input").is(":disabled")) {
                $(this).closest('#inputFormRow').find("input").attr("disabled", false);
            } else {
                $(this).closest('#inputFormRow').find("input[type=text]").attr("disabled", true);
                $(this).closest('#inputFormRow').find("input[type=number]").attr("disabled", true);
            }
        });

        $(document).ready(function() {

            $(document).on('change', '#units', function() {
                var unitId = this.value;
                if (unitId) {
                    $.ajax({
                        url: "<?php echo e(route('getPaymentPlans')); ?>",
                        method: 'POST',
                        data: {
                            _token: '<?php echo e(csrf_token()); ?>',
                            unit_id: unitId
                        },
                        success: function(data) {
                            let paymentPlans = '';
                            $.each(data.paymentPlans, function(key, value) {
                                paymentPlans +=

                                    `<option value="${value.id}">${value.years} years - ${value.total_price} total price</option>`;
                            });
                            $('#payment_plans').html(paymentPlans);
                        }
                    });
                }
            });
        });


        $(document).on('change', '#status', function() {
            var status = $(this).val();
            if (status === 'reserved') {
                $('#reservation-amount').show();
                $('#downpayment-amount').hide();
            } else if (status === 'downpayment') {
                $('#reservation-amount').hide();
                $('#downpayment-amount').show();
            } else {
                $('#reservation-amount').hide();
                $('#downpayment-amount').hide();
            }
        });
    </script>


    <!-- /.card -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/clients/reservation.blade.php ENDPATH**/ ?>