

<?php $__env->startSection('content'); ?>
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h2 class="card-title">Contracts</h2>&nbsp;&nbsp;
                <div style="float:right">
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('contracts-create')): ?>
                        <a href="<?php echo e(route('contracts.create')); ?>" title="Create Contract" class="btn btn-outline-light"><i
                                class="fas fa-plus"></i></a>
                    <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('contracts-clientContracts')): ?>
                        <a href="<?php echo e(route('ClientContracts')); ?>" title="Client Contracts" class="btn btn-outline-info"><i
                                class="fas fa-address-card"></i></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <div class="card-title">Total: <?php echo e(count($contracts)); ?></div>
            </div>
            <!-- /.card-body -->
            <div class="card-body">



                <table id=<?php echo e(auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('contracts-export') ? 'example1' : 'nonExport'); ?> 
                    class="table table-bordered table-striped" style="margin: unset">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Type</th>
                            <th>Creation Date</th>
                            <th>Creation Time</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $contracts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contract): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $temp = explode(' ', $contract->created_at->setTimezone('Africa/Cairo')); ?>
                            <tr>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-show')): ?>
                                        <a href="<?php echo e(route('contracts.show', $contract->id)); ?>">
                                            <?php echo e($contract->id); ?>

                                        </a>
                                    <?php else: ?>
                                        <?php echo e($contract->id); ?>

                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php echo e($contract->name); ?>

                                </td>
                                <td>
                                    <?php echo e($contract->type); ?>

                                </td>
                                <td><?php echo e($temp[0]); ?></td>
                                <td><?php echo e($temp[1]); ?></td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-print')): ?>
                                        <a class="btn btn-info" title="print"
                                            href="<?php echo e(route('printContract', $contract->id)); ?>">
                                            <i class="fa fa-print"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-edit')): ?>
                                        <a class="btn btn-primary" title="Edit"
                                            href="<?php echo e(route('contracts.edit', $contract->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>

                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('contracts-delete')): ?>
                                        <?php if(count($contract->contracts) == 0): ?>
                                            <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                                data-id="<?php echo e($contract->id); ?>" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>


    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('contracts.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/contracts/index.blade.php ENDPATH**/ ?>