

<?php $__env->startSection('content'); ?>
    <div class="container">
        <form action="<?php echo e(route('units.update', $unit->id)); ?>" method="post">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <input type="hidden" name="is_active" value="<?php echo e($unit->is_active); ?>">

            <div class="row justify-content-between">
                <!-- Unit Information -->
                <div class="card card-info col-5">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Name</label>
                                    <input type="text" name="name" class="form-control"
                                        value="<?php echo e($unit->name ?? ''); ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <?php if($unit->building->phase->project->is_residential == 1): ?>
                                <div class="col-md-6">
                                    <div class="form-group row">
                                        <label class="col-3">Floor</label>
                                        <select name="floor" id="floor" class="form-control col-6">
                                            <option value="0" <?php echo e($unit->floor == 0 ? 'selected' : ''); ?>>G</option>
                                            <?php for($i = 1; $i <= $unit->building->number_of_floors; $i++): ?>
                                                <option value="<?php echo e($i); ?>"
                                                    <?php echo e($unit->floor == $i ? 'selected' : ''); ?>><?php echo e($i); ?></option>
                                            <?php endfor; ?>
                                        </select>
                                    </div>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="floor" value="0">
                            <?php endif; ?>
                        </div>

                        <!-- Checkbox for Roof and Garden -->
                        <div class="row">
                            <div class="form-group col-5">
                                <input type="checkbox" id="roof" name="has_roof" style="width:25px;height:25px;"
                                    <?php echo e($unit->roof_space != 0 ? 'checked' : ''); ?>>
                                <label style="margin-left:10px;" for="roof">Has Roof?</label>
                            </div>
                            <div class="form-group col-5">
                                <input type="checkbox" id="garden" name="has_garden" style="width:25px;height:25px;"
                                    <?php echo e($unit->garden_space != 0 ? 'checked' : ''); ?>>
                                <label style="margin-left:10px;" for="garden">Has Garden?</label>
                            </div>
                        </div>

                        <!-- Garden and Roof Space -->
                        <div class="row">
                            <div id="ground"
                                style="<?php echo e($unit->floor == 0 && $unit->garden_space ? '' : 'display:none;'); ?>">
                                <div class="form-group">
                                    <label><?php echo e($unit->building->type == 'Residential' ? 'Garden Space' : 'Out-area Space '); ?></label>
                                    <input type="number" step="any" name="garden_space" class="form-control"
                                        value="<?php echo e($unit->garden_space ?? ''); ?>">
                                </div>
                            </div>
                            <div id="roof-space" style="<?php echo e($unit->roof_space ? '' : 'display:none;'); ?>">
                                <div class="form-group">
                                    <label>Roof Space</label>
                                    <input type="number" step="any" name="roof_space" class="form-control"
                                        value="<?php echo e($unit->roof_space ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Unit Space -->
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Unit Space</label>
                                    <input type="number" step="any" name="unit_space" class="form-control"
                                        value="<?php echo e($unit->unit_space ?? ''); ?>" required>
                                </div>
                            </div>
                        </div>

                        <!-- Bedrooms, Bathrooms, Dressing -->
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>BedRooms</label>
                                    <input type="number" name="bedrooms" class="form-control"
                                        value="<?php echo e($unit->bedrooms ?? ''); ?>">
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>BathRooms</label>
                                    <input type="number" name="bathrooms" class="form-control"
                                        value="<?php echo e($unit->bathrooms ?? ''); ?>">
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="form-group">
                                    <label>Dressing</label>
                                    <input type="number" name="dressing" class="form-control"
                                        value="<?php echo e($unit->dressing ?? ''); ?>">
                                </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea name="description" cols="30" rows="4" class="form-control"><?php echo e($unit->description); ?></textarea>
                                </div>
                            </div>
                        </div>

                        <!-- View Dropdown -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>View</label>
                                    <select name="view" class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $views; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $view): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($view->id); ?>"
                                                <?php echo e($view->id == $unit->view ? 'selected' : ''); ?>>
                                                <?php echo e($view->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Type Dropdown -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Type</label>
                                    <select name="type" class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($type->id); ?>"
                                                <?php echo e($type->id == $unit->type ? 'selected' : ''); ?>>
                                                <?php echo e($type->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Finishing Dropdown -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label>Finishing</label>
                                    <select name="finishing" class="form-control select2" style="width: 100%;">
                                        <?php $__currentLoopData = $finishings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $finishing): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($finishing->id); ?>"
                                                <?php echo e($finishing->id == $unit->finishing ? 'selected' : ''); ?>>
                                                <?php echo e($finishing->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Pricing Section -->
                <div class="card card-info col-5">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="form-group">
                                    <label>Unit Meter Price for cash</label>
                                    <input type="number" step="any" name="unit_meter_price" class="form-control"
                                        value="<?php echo e($unit->prices->where('years', 'cash')->first()->meter_price ?? 0); ?>"
                                        required>
                                </div>
                            </div>
                        </div>

                        <!-- Dynamic rows for multi-year pricing -->
                        <div id="inputContainer">
                            <?php $__currentLoopData = $unit->prices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($price->years !== 'cash'): ?>
                                    <div class="row inputRow">
                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Unit Meter Price</label>
                                                <input type="number" step="any" name="meter_price[]"
                                                    class="form-control" value="<?php echo e($price->meter_price); ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-sm-4">
                                            <div class="form-group">
                                                <label>Number of Years</label>
                                                <input type="number" name="years[]" class="form-control"
                                                    value="<?php echo e($price->years); ?>" required>
                                            </div>
                                        </div>


                                        <div class="col-sm-2">
                                            <button type="button" class="btn btn-danger removeRow">-</button>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="row">
                            <div class="col-sm-2">
                                <button type="button" id="addRow" class="btn btn-success form-control">+</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit button -->
            <div class="container" style="text-align: end">
                <button type="submit" class="btn btn-info">Submit</button>
            </div>
        </form>
    </div>

    <!-- JavaScript to handle dynamic fields, roof/garden visibility -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#floor').on('change', function() {
                if ($('#floor').val() == '0') {
                    $("#ground").show();
                } else {
                    $("#ground").hide();
                }
            });

            $('input[type="checkbox"]#roof').click(function() {
                if ($(this).is(":checked")) {
                    $("#roof-space").show();
                } else {
                    $("#roof-space").hide();
                }
            });

            $('input[type="checkbox"]#garden').click(function() {
                if ($(this).is(":checked")) {
                    $("#ground").show();
                } else {
                    $("#ground").hide();
                }
            });

            $('#addRow').click(function() {
                var newRow = `
                <div class="row inputRow">
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Unit Meter Price</label>
                            <input type="number" step="any" name="meter_price[]" class="form-control" value="0" required>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <label>Number of Years</label>
                            <input type="number" name="years[]" class="form-control" value="1" required>
                        </div>
                    </div>
                    <div class="col-sm-2">
                        <button type="button" class="btn btn-danger removeRow">-</button>
                    </div>
                </div>`;
                $('#inputContainer').append(newRow);
            });

            $(document).on('click', '.removeRow', function() {
                $(this).closest('.inputRow').remove();
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/units/edit.blade.php ENDPATH**/ ?>