
<?php $__env->startSection('content'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('swiper/swiper.css')); ?>">


    <style>
        #upload-photo {
            display: none;
        }

        #upload-file {
            display: none;
        }

        #carouselExampleControls .btn {
            position: absolute;
            top: 0%;
            right: 0%;
            background-color: transparent;

            opacity: 0.5;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: grey;


        }

        .w-100 {
            height: 400px !important
        }

        #carouselExampleControls .btn:hover {
            background-color: transparent;
            opacity: 3.0;
            color: white;
        }

        /* swiper ////////////////////////////////////*/
        .swiper {
            width: 240px;
            height: 320px;
        }

        .swiper .swiper-slide {
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 18px;
            font-size: 22px;
            font-weight: bold;
            color: #fff;
        }

        .swiper2 {
            width: 100%;
            padding-top: 50px;
            padding-bottom: 50px;
        }

        .swiper2 .swiper-slide {
            background-position: center;
            background-size: cover;
            width: 300px;
            height: 300px;
        }

        .swiper2 .swiper-slide img {
            display: block;
            width: 100%;
        }
    </style>

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-4">
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-edit')): ?>
                        <a href="<?php echo e(route('projects.edit', $project->id)); ?>">
                            <button class="btn btn-square btn-info" type="button"><i class="fas fa-pen"></i></button>
                        </a>
                    <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-delete')): ?>
                        <?php if(count($project->campaigns) == 0 && count($project->phases) == 0): ?>
                            <button onClick="clickDeletebutton(this)" title="Delete" style="height:38px;"
                                class="btn btn-danger" data-id="<?php echo e($project->id); ?>" data-toggle="modal"
                                data-target="#projectModals">
                                <i class="fa fa-ban"></i>
                            </button>
                        <?php endif; ?>
                    <?php endif; ?>

                </div>
                <form action="<?php echo e(route('ProjectfileUpload')); ?>" method="POST" enctype="multipart/form-data" class="col-7">
                    <?php echo csrf_field(); ?>

                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-uploadImages')): ?>
                        <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                            <i class="fas fa-file-image"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="images[]" id="upload-photo" multiple>
                    <?php endif; ?>

                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-uploadFiles')): ?>
                        <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                            <i class="fas fa-file-pdf"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="files[]" id="upload-file" multiple>
                    <?php endif; ?>


                    <input type="hidden" value="<?php echo e($project->id); ?>" name="project_id">

                    <button type="submit" title="upload" style="margin-bottom:10px;" class="btn btn-outline-info"><i
                            class="fas fa-check"></i></button>
                </form>
            </div>
            

        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-6">
                <table>
                    <tr>
                        <th>Project ID :</th>
                        <td><?php echo e($project->id ?? ''); ?></td>
                    </tr>
                    <tr>
                        <th>Project Name :</th>
                        <td><?php echo e($project->name ?? ''); ?></td>
                    </tr>
                    <tr>
                        <th>Description :</th>
                        <td><?php echo e($project->description ?? ''); ?></td>
                    </tr>
                    <tr>
                        <th>Mentainance :</th>
                        <td><?php echo e($project->mentainance ?? 0); ?></td>
                    </tr>
                    <tr>
                        <th>Active :</th>
                        <td><?php echo e($project->is_active == 0 ? 'Not Available' : 'Available'); ?></td>
                    </tr>
                    <tr>
                        <th>Type :</th>
                        <td><?php echo e($project->is_residential == 0 ? 'Not Residential' : 'Residential'); ?></td>
                    </tr>
                    <tr>
                        <th>Created at :</th>
                        <td><?php echo e($project->created_at); ?></td>
                    </tr>

                </table>
                <hr>

            </div>
            <div class="col-6">
                
                <div class="card collapsed-card card-outline">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Facilities
                        </h3>

                    </div>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-facilities')): ?>
                        <div class="card-body">
                            <table>
                                <?php $__currentLoopData = $project->facilities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $facility): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>*<?php echo e($facility->name); ?> </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>

                
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Accessed Users
                        </h3>

                    </div>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-accessedUsers')): ?>
                        <div class="card-body">
                            <table>
                                <?php $__empty_1 = true; $__currentLoopData = $project->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td title="<?php echo e($user->role->name); ?>">
                                            <a href="<?php echo e(route('users.show', $user->id)); ?>">
                                                <?php echo e($user->name); ?>

                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Campaigns
                        </h3>

                    </div>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-campaigns')): ?>
                        <div class="card-body">
                            <?php $__empty_1 = true; $__currentLoopData = $project->campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <a href="<?php echo e(route('campaigns.show', $campaign->id)); ?>">
                                    <label class="">*<?php echo e($campaign->name); ?>: </label>
                                </a>
                                <label class=""> <?php echo e($campaign->created_at); ?></label><br>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Attached Files
                        </h3>
                    </div>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-files')): ?>
                        <div class="card-body">
                            <?php $__empty_1 = true; $__currentLoopData = $project->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <a href="<?php echo e(URL::to('/')); ?>/files/<?php echo e($file->file); ?>">
                                            <?php echo e($file->file); ?>-<?php echo e($file->created_at); ?>

                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Gallery
                        </h3>
                    </div>
                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-gallery')): ?>
                        <div class="card-body">
                            <div class="swiper mySwiper" id="mySwiper" data-toggle="modal" data-target="#imageGallery">
                                <div class="swiper-wrapper">
                                    <?php $__currentLoopData = $project->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="swiper-slide">
                                            <img class="swiper-slide" src="<?php echo e(URL::to('/')); ?>/images/<?php echo e($value->name); ?>"
                                                alt="<?php echo e($value->name); ?>" />
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer">
        
        <?php if(auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('phases-read')): ?>
            <div class="card card-outline ">
                <div class="card-header">
                    <h3 class="card-title" style="font-weight:bold;font-size:23px;">Phases<br>
                        <p>Total: <?php echo e(count($phases)); ?></p>
                    </h3>

                    <?php if(auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('phases-create')): ?>
                        <a href="<?php echo e(route('phases.create', 'id=' . $project->id)); ?>" style="float:right">
                            <button class="btn btn-square btn-light active" type="button"><i
                                    class="fas fa-plus"></i></button>
                        </a>
                    <?php endif; ?>

                </div>
                <div class="card-body">
                    <table class=" table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                <?php if($project->is_residential == 0): ?>
                                    <th>Type</th>
                                <?php endif; ?>
                                <th>Availability</th>
                                <th>Created Date</th>
                                <th>Created Time</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $temp = explode(' ', $phase->created_at->setTimezone('Africa/Cairo')); ?>

                                <td><?php echo e($phase->id); ?></td>
                                <td>
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('phases-show')): ?>
                                        <a href="<?php echo e(route('phases.show', $phase->id)); ?>">
                                            <?php echo e($phase->name); ?>

                                        </a>
                                    <?php else: ?>
                                        <?php echo e($phase->name); ?>

                                    <?php endif; ?>
                                </td>
                                <?php if($project->is_residential == 0): ?>
                                    <td><?php echo e($phase->type ?? ''); ?></td>
                                <?php endif; ?>
                                <td><?php echo e($phase->is_active == 0 ? 'Not Available' : 'Available'); ?></td>
                                <td><?php echo e($temp[0] ?? ''); ?></td>
                                <td><?php echo e($temp[1] ?? ''); ?></td>
                                <td style="text-align:center;">
                                    <?php if(auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('phases-edit')): ?>
                                        <a class="btn btn-info" title="Edit"
                                            href="<?php echo e(route('phases.edit', $phase->id)); ?>">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    <?php endif; ?>
                                </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
        <?php endif; ?>
        
    </div>
    </div>

    
    <div class="modal fade" id="projectModals" tabindex="-1" role="dialog" aria-labelledby="projectModals"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <?php if(count($project->phases) == 0): ?>
                        <p>Are you sure to delete this record ?</p>
                    <?php else: ?>
                        <p>this project has phases you can't delete this project</p>
                    <?php endif; ?>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <?php if(count($project->phases) == 0): ?>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    <?php endif; ?>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this Image ?</p>
                </div>
                <form class="modal-footer" method="post">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <!-- gallery Image from Slider Modal -->
    <div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content"
                style="background-color: unset;
                        box-shadow: unset;
                        border: unset;">
                <div class="modal-body">
                    <div class="swiper2 mySwiper2">
                        <div class="swiper-wrapper">
                            <?php $__currentLoopData = $project->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="swiper-slide">
                                    <img style="position: absolute" src="<?php echo e(URL::to('/')); ?>/images/<?php echo e($value->name); ?>"
                                        alt="<?php echo e($value->name); ?>" />
                                    <button style="position: relative; float:right;color:white;font-size:30px"
                                        class="btn">×</button>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="module" src="<?php echo e(asset('swiper/swiper.js')); ?>"></script>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('projects.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#projectModals').find($('form')).attr('action', route);
        }

        clickDelete = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('galleries.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#image').find($('form')).attr('action', route);
        }

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('phases.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#phaseModals').find($('form')).attr('action', route);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/projects/show.blade.php ENDPATH**/ ?>