
<!-- namespace App; -->


<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body register-card-body mt-5 ml-4">

        <form action="<?php echo e(route('leads.update',$lead->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>
            <input type="hidden" value="<?php echo e($lead->id); ?>" name="id">
            <div class="row">
                <div class="col-6">
                    <div class="row">
                        <div class="form-group col-10">
                            <label>Name</label>
                            <input type="text" name="name" value="<?php echo e(old('name',$lead->name)); ?>" class="form-control" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-5">
                            <label>Job Title</label>
                            <input type="text" class="form-control" value="<?php echo e(old('job_title',$lead->job_title)); ?>"
                                name="job_title">
                        </div>
                        <div class="form-group col-5">
                            <label>Email</label>
                            <input type="email" class="form-control" placeholder="email@example.com"
                                value="<?php echo e(old('email',$lead->email)); ?>" name="email">
                        </div>
                    </div>
                    <div class="form-group col-10">
                        <label>Note</label>
                        <textarea type="text" class="form-control" placeholder="Note..."
                            value="<?php echo e(old('note')); ?>" name="note"><?php echo e($lead->note ?? ''); ?></textarea>
                    </div>
                    <div class="row">
                        <div class="form-group col-5">
                            <label>Contact Tools</label>
                            <select name="contact_tool" class="select2 custom-select form-control-border">
                                <option></option>
                                <option value="phone" <?php echo e($lead->contact_tool == 'phone' ? 'selected' : ''); ?>>phone</option>
                                <option value="email" <?php echo e($lead->contact_tool == 'email' ? 'selected' : ''); ?>>email</option>
                                <option value="whatsApp" <?php echo e($lead->contact_tool == 'whatsApp' ? 'selected' : ''); ?>>whatsApp
                                </option>
                                <option value="visit" <?php echo e($lead->contact_tool == 'visit' ? 'selected' : ''); ?>>visit</option>
                                <option value="facebook" <?php echo e($lead->contact_tool == 'facebook' ? 'selected' : ''); ?>>facebook
                                </option>
                                <option value="walk-in" <?php echo e($lead->contact_tool == 'walk-in' ? 'selected' : ''); ?>>walk-in
                                </option>
                            </select>
                        </div>

                        <div class="form-group col-5">
                            <label>Reply Options</label>
                            <select name="reply_option" class="select2 custom-select form-control-border">
                                <option></option>
                                <option value="replied" <?php echo e($lead->reply_option == 'replied' ? 'selected' : ''); ?>>replied
                                </option>
                                <option value="switched-off" <?php echo e($lead->reply_option == 'switched-off' ? 'selected' : ''); ?>>
                                    switched off</option>
                                <option value="no-answer" <?php echo e($lead->reply_option == 'no-answer' ? 'selected' : ''); ?>>no
                                    answer
                                </option>
                                <option value="wrong-number" <?php echo e($lead->reply_option == 'wrong-number' ? 'selected' : ''); ?>>
                                    wrong number</option>
                                <option value="thanks-for-calling"
                                    <?php echo e($lead->reply_option == 'thanks-for-calling' ? 'selected' : ''); ?>>thanks for calling
                                </option>
                                <option value="thanks-for-meeting"
                                    <?php echo e($lead->reply_option == 'thanks-for-meeting' ? 'selected' : ''); ?>>thanks for meeting
                                </option>
                                <option value="Set-a-meeting"
                                    <?php echo e($lead->reply_option == 'Set-a-eeting' ? 'selected' : ''); ?>>Set
                                    a Meeting</option>
                            </select>
                        </div>

                        <div class="form-group col-4">
                            <label>Purpose</label>
                            
                            <select name="purpose" class="select2 custom-select form-control-border">
                                <option></option>
                                <option value="investment" <?php echo e($lead->purpose == 'investment' ? 'selected' : ''); ?>>
                                    investment
                                </option>
                                <option value="housing" <?php echo e($lead->purpose == 'housing' ? 'selected' : ''); ?>>housing
                                </option>
                                <option value="for-children" <?php echo e($lead->purpose == 'for-children' ? 'selected' : ''); ?>>
                                    for-children</option>
                                <option value="vacation" <?php echo e($lead->purpose == 'vacation' ? 'selected' : ''); ?>>vacation
                                </option>
                                <option value="2nd-home" <?php echo e($lead->purpose == '2nd-home' ? 'selected' : ''); ?>>2nd-home
                                </option>
                            </select>
                        </div>

                        <div class="form-group col-2">
                            <label>Segments</label>
                            <select name="segment" class="select2 custom-select form-control-border">
                                <option></option>
                                <option value="A+" <?php echo e($lead->segment == 'A+' ? 'selected' : ''); ?>>A+</option>
                                <option value="A" <?php echo e($lead->segment == 'A' ? 'selected' : ''); ?>>A</option>
                                <option value="B+" <?php echo e($lead->segment == 'B+' ? 'selected' : ''); ?>>B+</option>
                                <option value="B" <?php echo e($lead->segment == 'B' ? 'selected' : ''); ?>>B</option>
                                <option value="C+" <?php echo e($lead->segment == 'C+' ? 'selected' : ''); ?>>C+</option>
                                <option value="C" <?php echo e($lead->segment == 'C' ? 'selected' : ''); ?>>C</option>
                            </select>
                        </div>

                        <div class="form-group col-4">
                            <label>Tags</label>
                            <select name="tag" class="select2 custom-select form-control-border">
                                <option></option>
                                <option value="VIP" <?php echo e($lead->tag == 'VIP' ? 'selected' : ''); ?>>VIP</option>
                                <option value="urgent" <?php echo e($lead->tag == 'urgent' ? 'selected' : ''); ?>>urgent</option>
                                <option value="potential-client" <?php echo e($lead->tag == 'potential-client' ? 'selected' : ''); ?>>
                                    potential-client</option>
                                <option value="reassign" <?php echo e($lead->tag == 'reassign' ? 'selected' : ''); ?>>Reassign</option>
                                <option value="none" <?php echo e($lead->tag == 'none' ? 'selected' : ''); ?>>none</option>
                            </select>
                        </div>
                    </div>

                </div>
                <div class="col-6">
                    <div class="card card-outline card-info">
                        <div class="card-header">
                            <h5><?php echo e(ucfirst($lead->type)); ?> Data</h5>
                        </div>
                        <?php if($lead->type == 'lead'): ?>
                        <div class="row card-body" id="leadData">
                            <div class="form-group col-5">
                                <label>Campaign</label>
                                <select name="campaign_id" class="custom-select form-control-border" id="campaigns">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($lead->campaign_id == $campaign->id ? 'selected' : ''); ?> value="<?php echo e($campaign->id); ?>"><?php echo e($campaign->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-5">
                                <label for="sources">Choose source</label>
                                <select name="source_id" id="sources" class="select2 custom-select form-control-border">
                                    
                                </select>
                            </div>
                            <label for="sources">Current Source: <?php echo e($lead->source?->name); ?></label>
                        </div>
                        <?php endif; ?>
                        <?php if($lead->type == 'cil'): ?>
                        <div class="row card-body" id="CilData">
                            <div class="form-group col-10">
                                <label for="civil_id">Civil ID number</label>
                                <input id="civil_id" type="number" class="form-control" value="<?php echo e($lead->civil_id); ?>"
                                    name="civil_id">
                            </div>
                            <div class="form-group col-5">
                                <label>Brokers</label>
                                <select name="broker_id" class="select2 custom-select form-control-border" id="brokers">
                                    <?php $__currentLoopData = $brokers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $broker): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($broker->id); ?>"
                                        <?php echo e($lead->broker_id == $broker->id ? 'selected' : ''); ?>>
                                        <?php echo e($broker->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group col-5">
                                <label for="note">Note</label>
                                <textarea name="note" id="note" class="form-control"
                                    placeholder="Note...."><?php echo e($lead->note); ?></textarea>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <!-- /.col -->
    </div>
    <div class="card-footer">
        <div class="col-10" style="display:flex;justify-content:center;">
            <button type="submit" class="btn btn-info">Submit</button>
        </div>

    </div>
    </form>
</div>
<!-- /.form-box -->
</div><!-- /.card -->

<script src="<?php echo e(asset('asset/plugins/jquery/jquery.min.js')); ?>"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
// add row
$("#addRow").click(function() {
    var html = '';
    html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-3">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="Country">
                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?> +<?php echo e($country->phonecode); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" value="<?php echo e(old('phone_number')); ?>"
                    placeholder="Phone Number" id="phone" name="mobile_number[]">
            </div>
                    
            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

    $('#newRow').append(html);
});

// remove row
$(document).on('click', '#removeRow', function() {
    $(this).closest('#inputFormRow').remove();
});


$(document).on('change', '#campaigns', function() {
    // console.log(this.value);
    var data = this.value;

    $.ajax({
        data: {
            'campaign_id': data
        },
        method: "POST",
        url: "<?php echo e(route('campaignSources')); ?>",

        success: function(dataResult) {
            var dataResult = JSON.parse(dataResult);
            console.log(dataResult.sources);
            let sources = "";


            Array.from(dataResult.sources).forEach(myFunction2);

            function myFunction2(item, index) {
                sources += `<option value="` + item.id + `">` + item.name + `</option>`;
            }
            document.getElementById("sources").innerHTML = sources;
        }
    });
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/leads/edit.blade.php ENDPATH**/ ?>