
<?php $__env->startSection('content'); ?>
    
    <!-- End filters -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Delay Leads</h4>
                            <p>Total: <?php echo e(count($leads)); ?></p>
                            <br>
                            <div class="btn-group">
                                <!-- <button type="button" class="btn btn-default">Action</button> -->
                                <button type="button" title="bulk action"
                                    class="btn btn-light active dropdown-toggle dropdown-icon" data-toggle="dropdown">
                                    <span class="sr-only">Toggle Dropdown</span>
                                </button>
                                <div class="dropdown-menu" role="menu">
                                    
                                    <a class="dropdown-item" data-toggle="modal" onClick="clickbutton(this)"
                                        data-target='#assignedUserModal' href="#">Assigned User</a>
                                    

                                    
                                </div>
                            </div>
                            
                            <?php if(auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission(' leads-delaytime')): ?>
                                <a href="<?php echo e(route('unitSettings.index')); ?>" style="float:right" class="btn btn-outline-dark"
                                    title="Manage DelayTime">
                                    <i class="fas fa-hourglass-end"></i>
                                </a>
                            <?php endif; ?>
                            <div class="card-body">


                                <table
                                    id=<?php echo e(auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('delay-leads-export')? 'example1': 'nonExport'); ?>

                                    class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th><input type="checkbox" id="selectAll" class="sub_chk"></th>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Phone Number</th>
                                            <th>Source</th>
                                            <th>Campaign</th>
                                            <th>Status</th>
                                            <th>comunication</th>
                                            <th>Created Date</th>
                                            <th>Created Time</th>

                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $temp = explode(' ', $lead->created_at->setTimezone('Africa/Cairo')); ?>

                                            <tr>
                                                <td><input type="checkbox" id="chk_lead" class="checkboxAll sub_chk"
                                                        data-id="<?php echo e($lead->id); ?>">
                                                </td>
                                                <td><?php echo e($lead->id); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('leads.show', $lead->id)); ?>"><?php echo e($lead->name); ?></a>
                                                </td>
                                                <td><?php echo e($lead->email); ?></td>
                                                <!-- Phone number -->
                                                <td>
                                                    <?php $__currentLoopData = $lead->phone_numbers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phone_number): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li><?php echo e($phone_number->phone); ?></li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td><?php echo e($lead->came_from); ?></td>
                                                <td><?php echo e($lead->campaign?->name ?? ''); ?></td>
                                                <!--LEAD STATUSES -->
                                                <?php if($lead->status == 'new' || $lead->status == 'recycled' || $lead->status == 'converted'): ?>
                                                    <td class="badge badge-primary"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php elseif(
                                                    $lead->status == 'in-process' ||
                                                        $lead->status == 'pending' ||
                                                        $lead->status == 'following' ||
                                                        $lead->status == 'wait'): ?>
                                                    <td class="badge badge-info" style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php elseif(
                                                    $lead->status == 'not-interested' ||
                                                        $lead->status == 'unreachable' ||
                                                        $lead->status == 'no-answer' ||
                                                        $lead->status == 'wrong-number'): ?>
                                                    <td class="badge badge-dark" style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php elseif(
                                                    $lead->status == 'follow_up' ||
                                                        $lead->status == 'closed-outside' ||
                                                        $lead->status == 'interestad' ||
                                                        $lead->status == 'meeting'): ?>
                                                    <td class="badge badge-warning"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php elseif($lead->status == 'low-budget'): ?>
                                                    <td class="badge badge-light"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php elseif($lead->status == 'done-deal'): ?>
                                                    <td class="badge badge-success"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php else: ?>
                                                    <td class="badge badge-danger"
                                                        style=" margin-top:12px;margin-left:10px;">
                                                        <?php echo e(ucwords($lead->status)); ?>

                                                    </td>
                                                <?php endif; ?>

                                                <td><?php echo e($lead->type); ?></td>
                                                <td><?php echo e($temp[0]); ?></td>
                                                <td><?php echo e($temp[1]); ?></td>
                                                <td>
                                                    

                                                    <a class="btn btn-info" title="Edit"
                                                        href="<?php echo e(route('leads.edit', $lead->id)); ?>">
                                                        <i class="fa fa-pen"></i>
                                                    </a>

                                                    


                                                    
                                                    <button onClick="clickDeletebutton(this)" title="Archive"
                                                        class="btn btn-danger" data-id="<?php echo e($lead->id); ?>"
                                                        data-toggle="modal" data-target="#exampleModalCenter">
                                                        <i class="fa fa-ban"></i>
                                                    </button>
                                                    

                                                    <!-- <a class="btn btn-success" title="Next Action"
                                                                href="<?php echo e(route('communications.create', $lead->id)); ?>">
                                                                <i class="fas fa-calendar"></i>
                                                            </a> -->
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div id="assignedUserModal" class="modal fade">
            <div class="modal-dialog">
                <form id="leadData">
                    <div class="modal-content">
                        <div class="modal-body">
                            <select name="user_id" class="select2 custom-select form-control-border" id="user_id">
                                <option value=""></option>
                                <?php if(auth()->user()->type == 'admin'): ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $UserChildren; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <option <?php echo e(old('user_id') == $user->id ? 'selected' : ''); ?>

                                            value="<?php echo e($user->id); ?>">
                                            <?php echo e($user->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php for($i = 0; $i < count($UserChildren); $i++): ?>
                                        <option value="<?php echo e($UserChildren[$i]['id']); ?>">
                                            <?php echo e($UserChildren[$i]['name']); ?>

                                        </option>
                                    <?php endfor; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary yes" type="button">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Archive Record</h5>
                        <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure to Archive this Lead ?</p>
                    </div>
                    <form class="modal-footer" method="post">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <script>
        clickbutton = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                console.log(leadIds)
                return $(this).data('id')
            }).get();
            var route = "<?php echo e(route('leads.bulkAction', ':id')); ?>";
            route = route.replace(':id', leadIds);
            $('#assignedUserModal').find($('form')).attr('action', route);
        }

        changeStatus = (e) => {
            var leadIds = $('.sub_chk:checkbox:checked').map(function() {
                return $(this).data('id')
            }).get();
            var route = "<?php echo e(route('leads.bulkAction', ':id')); ?>";
            route = route.replace(':id', leadIds);
            $('#statusModal').find($('form')).attr('action', route);
        }
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "<?php echo e(route('leads.destroy', ':id')); ?>";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('../welcome', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/rfg/public_html/demo/resources/views/leads/delayLeads.blade.php ENDPATH**/ ?>