@extends ('../welcome')


@section('content')
    <style>
        a {
            color: gray;
             !important;
        }

        a:hover {
            color: #17a2b8;
             !important;
            font-weight: bold;
        }
    </style>
    <div class="row">
        <div class="card card-info card-outline">
            <div class="card-header">
                <div class="btn btn-tool" data-card-widget="collapse">
                    Extra Permissions
                </div>
            </div>
            <div class="card-body">
                @forelse($user->Permissions as $permission)
                    <p>{{ $permission->display_name }}</p>
                @empty
                    <p>No Extra Permissions for this user</p>
                @endforelse
            </div>

        </div>
        <div class="col-3">
            <div class="card card-info card-outline">
                <div class="card-body box-profile">
                    <h3 class="profile-username text-center">{{ $user->name }}</h3>
                    <p class="text-center">
                        {{ $user->role?->name ?? '' }}
                    </p>
                    <p class="text-center">Leader:
                        {{ $user->parent?->name ?? '' }}
                    </p>
                    <p class="text-muted text-center">{{ $user->email }}</p>
                    <p class="text-muted text-center">
                        @forelse($user->phones as $phone)
                            <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                {{ $phone->country->phonecode }}-{{ $phone->phone }}
                            </a>
                            <br>
                        @empty
                        @endforelse
                        <br>
                    <div class="row">
                        <div>
                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('users-edit'))
                                <a class="btn btn-info" title="Edit" href="{{ route('users.edit', $user->id) }}">
                                    <i class="fas fa-pen"></i>
                                </a>
                            @endif
                            
                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('users-block'))
                                <a type="submit" title="Block" class="btn btn-danger"
                                    href="{{ route('block', $user->id) }}">
                                    <i class="fas fa-ban"></i>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
