@extends ('../welcome')


@section('content')

    <div class="card col-12">
        <div class="card-header">
            <h4 class="card-title"><strong>Users</strong></h4>
            <br>
            <lable><span style="font-size:18px;font-weight:bold">Total: </span> {{ count($UserChildren) }}</lable>
            <div style="float:right;">
                @if(auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('users-export'))
                <a href="{{ route('users.export') }}?{{ request()->getQueryString() }}" style="float:right; margin-right: 10px;">
                    <button class="btn btn-outline-primary" title="Export" type="button"><i
                            class="fas fa-download"></i> Export</button>
                </a>
                @endif
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-create'))
                    <a href="{{ route('addUser') }}" title="Create user" class="btn btn-light active"><i
                            class="fa fa-plus"></i></a>
                @endif
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-tree'))
                    <a href="{{ route('usersTree') }}" title="view tree" class="btn btn-success"><i
                            class="fa fa-tree"></i></a>
                @endif

                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('users-blocklist'))
                    <a href="{{ route('blocklist') }}" title="Block List" class="btn btn-danger"><i
                            class="fa fa-user-lock"></i></a>
                @endif

            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table class="table table-bordered" id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('users-export') ? 'example1' : 'nonExport' }} 
                >
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone Numbers</th>
                        <th style="text-align:center;">Role</th>
                        <th style="text-align:center;">Leader</th>
                        <th>Created at</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>

                    @if (auth()->user()->type == 'admin' || auth()->user()->role->name == 'Operation Specialist')
                        @forelse ($UserChildren as $user)
                            <tr >
                                <td>{{ $user->id }}</td>
                                <td class='clickable-row' data-href='{{ route('users.show', $user->id) }}'>
                                    {{ $user->name ?? '' }}
                                </td>
                                <td>{{ $user->email ?? '' }}</td>

                                <td>
                                    @foreach ($user->phones as $phone)
                                        {{-- redirect to whatsapp --}}
                                        <a href="https://wa.me/{{ $phone->country->phonecode}}{{ $phone->phone}}" target="_blank">
                                            {{ $phone->country->name ?? '' }} - {{ $phone->phone ?? '' }}
                                        </a>
                                    @endforeach
                                </td>
                                <td>{{ $user->role?->name ?? '' }}</td>
                                <td>{{ $user->parent?->name ?? '' }}</td>
                                <td>{{ $user->created_at }}</td>
                                <td>

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-edit'))
                                        <a class="btn btn-info" title="Edit" href="{{ route('users.edit', $user->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif

                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('users-block'))
                                        <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                            class="btn btn-danger" data-id="{{ $user->id }}" data-toggle="modal"
                                            data-target="#exampleModalCenter">
                                            <i class="fa fa-ban"></i>
                                        </button>
                                    @endif
                                </td>
                            </tr>
                        @empty
                        @endforelse
                    @else
                        @for ($i = 0; $i < count($UserChildren); $i++)
                            <option value="{{ $UserChildren[$i]['id'] }}">
                                <tr class='clickable-row' data-href='{{ route('users.show', $UserChildren[$i]['id']) }}'>
                                    <td>{{ $UserChildren[$i]['id'] }}</td>
                                    <td>
                                        {{ $UserChildren[$i]['name'] ?? '' }}
                                    </td>
                                    <td>{{ $UserChildren[$i]['email'] ?? '' }}</td>
                                    <td>{{ $UserChildren[$i]['created_at'] ?? '' }}</td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-edit'))
                                            <a class="btn btn-info" title="Edit"
                                                href="{{ route('users.edit', $UserChildren[$i]['id']) }}">
                                                <i class="fa fa-pen"></i>
                                            </a>
                                        @endif
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-block'))
                                            <button onClick="clickDeletebutton(this)" type="button" title="Delete"
                                                class="btn btn-danger" data-id="{{ $user->id }}" data-toggle="modal"
                                                data-target="#exampleModalCenter">
                                                <i class="fa fa-ban"></i>
                                            </button>
                                        @endif
                                    </td>
                                </tr>
                            </option>
                        @endfor
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <!-- Archive Lead Modal -->
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive User</h5>
                    <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>Are you sure to Archive this User ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('users.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }
    </script>
@endsection
