@extends ('../welcome')


@section('content')
    <form action="{{ route('storeUser') }}" method="POST">

        <div class="card">
            <div class="row">
                <div class="col-6">
                    <div class="register-box">
                        <div class="card-body register-card-body">
                            <p class="login-box-msg">Add new membership</p>
                            @csrf
                            <div class="input-group mb-3">
                                <input type="text" name="name" class="form-control" placeholder="Full name" required
                                    autofocus>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-user"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="email" class="form-control" placeholder="Email" name="email" require>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-envelope"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input class="form-control" placeholder="Password" type="password" name="password" required
                                    autocomplete="new-password">
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="input-group mb-3">
                                <input type="password" class="form-control" placeholder="Retype password" type="password"
                                    name="password_confirmation" required>
                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-lock"></span>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="userRole">Select User Role</label>
                                <select name="role_id" class="select2 custom-select form-control-border" id="userRole">
                                    @if (auth()->user()->type == 'admin')
                                        @foreach ($RoleChildren as $child)
                                            <option value="{{ $child->id }}">{{ $child->name }}</option>
                                        @endforeach
                                    @else
                                        @for ($i = 0; $i < count($RoleChildren); $i++)
                                            <option value="{{ $RoleChildren[$i]['id'] }}">{{ $RoleChildren[$i]['name'] }}
                                            </option>
                                        @endfor
                                    @endif
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="userTeams">Assign To leader</label>
                                <select name="assigned_to" class="select2 custom-select form-control-border" id="userTeams">
                                    <option value="">--</option>
                                    @if (auth()->user()->type == 'admin')
                                        @foreach ($UserChildren as $child)
                                            <option value="{{ $child->id }}">{{ $child->name }}</option>
                                        @endforeach
                                    @else
                                        @for ($i = 0; $i < count($UserChildren); $i++)
                                            <option value="{{ $UserChildren[$i]['id'] }}">{{ $UserChildren[$i]['name'] }}
                                            </option>
                                        @endfor
                                    @endif
                                </select>
                            </div>

                            <div class="col-6" style="float:right;">
                                <button type="submit" class="btn btn-primary">Add Member</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div id="inputFormRow">
                        <div class="row card-body">
                            <div class="col-4">
                                <p class="login-box-msg">Country</p>
                                <select name="country_id[]" class="select2 custom-select form-control-border"
                                    id="Country">
                                    @foreach ($countries as $country)
                                        <option value="{{ $country->id }}">{{ $country->name }}
                                            +{{ $country->phonecode }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-6">
                                <p class="login-box-msg">phone number</p>
                                <input type="text" class="form-control m-input" value="{{ old('phone_number') }}"
                                    placeholder="Phone Number" name="mobile_number[]" id="phone" required>
                            </div>

                            <button id="addRow" type="button" class="btn btn-info" style="margin-top:33px">
                                <i class="fas fa-plus"></i>
                            </button>
                        </div>
                        <div id="newRow"></div>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="select2 custom-select form-control-border" id="Country">
                    @foreach ($countries as $country)
                    <option value="{{ $country->id }}">{{ $country->name }} +{{ $country->phonecode }}</option>
                    @endforeach
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" value="{{ old('phone_number') }}"
                    placeholder="Phone Number" minlength="9" id="phone" oninvalid="this.setCustomValidity('Minimum length is 9 char')" name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });
        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script>
@endsection
