@extends ('../welcome')
@section('content')
<link rel="stylesheet" href="{{ asset('swiper/swiper.css') }}">


<style>
    #upload-photo {
        display: none;
    }

    #upload-file {
        display: none;
    }

    #carouselExampleControls .btn {
        position: absolute;
        top: 0%;
        right: 0%;
        background-color: transparent;

        opacity: 0.5;
        color: white;
        border: none;
        cursor: pointer;
        border-radius: 5px;
        color: grey;


    }

    .w-100 {
        height: 400px !important
    }

    #carouselExampleControls .btn:hover {
        background-color: transparent;
        opacity: 3.0;
        color: white;
    }

    /* swiper ////////////////////////////////////*/
    .swiper {
        width: 240px;
        height: 320px;
    }

    .swiper .swiper-slide {
        display: flex;
        align-items: center;
        justify-content: center;
        border-radius: 18px;
        font-size: 22px;
        font-weight: bold;
        color: #fff;
    }


    .swiper2 {
        width: 100%;
        padding-top: 50px;
        padding-bottom: 50px;
    }

    .swiper2 .swiper-slide {
        background-position: center;
        background-size: cover;
        width: 300px;
        height: 300px;
    }

    .swiper2 .swiper-slide img {
        display: block;
        width: 100%;
    }

    td,
    th {
        font-size: 15px;
    }

    #editAndHistory {
        width: 440px;
    }

    #files {
        width: 255px;
    }

    #is_delivered {
        width: 20px !important;
        height: 20px !important;
    }

    .select2.select2-container.select2-container--bootstrap4 {
        width: unset !important;
    }
</style>

<div class="card">
    <div class="card-header">
        <button title="Actions" class="btn btn-light active dropdown-toggle dropdown-icon" data-toggle="dropdown">
            Actions
            <span class="sr-only">Toggle Dropdown</span>
        </button>
        <div class="dropdown-menu" role="menu">
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-edit'))
            <a title="edit" href="{{ route('units.edit', $unit->id) }}" class="dropdown-item">
                Edit
            </a>
            @endif
            @if (!empty($unit->client))
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-delete'))
            <button title="Discard" class="dropdown-item" data-toggle="modal" data-target="#unitDelete">
                Discard
            </button>
            @endif
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-transfare'))
            <button title="Transfare To another client" class="dropdown-item" data-toggle="modal" data-target="#transfareUnit">
                Transfare
            </button>
            @endif
            @endif
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-history'))
            <a title="History" href="{{ route('unitsHistory', $unit->id) }}" class="dropdown-item">
                History
            </a>
            @endif
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-hidding'))
            <button class="dropdown-item" data-toggle="modal" data-target="#hidding">
                {{ $unit->is_active == 0 ? 'unhide' : 'hide' }}
            </button>
            @endif

            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-uplaodImages') ||
            auth()->user()->role->hasPermission('units-uploadFiles'))
            <button class="dropdown-item" data-toggle="modal" data-target="#uploadFiles" title="upload Files of images">
                Upload
            </button>
            @endif
            @if ($unit->status != 'free')
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-delivery-control'))
            <button class="dropdown-item" data-toggle="modal" data-target="#delivery" title="Delivery Managment">
                Delivery Managment
            </button>
            @endif
            @endif

            @if ($unit->client_id != null)
            @if (
            $unit->status != 'delivered' ||
            auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-update-reservation'))
            <button class="dropdown-item" data-toggle="modal" data-target="#reservation" title="Reservation Managment">
                Reservation Managment
            </button>
            @endif
            @endif

            @php
            $clients_id = $unit->contracts->pluck('client_id');
            $ids = json_decode($clients_id);
            @endphp
            @if (!empty($unit->client_id))
            @if (in_array($unit->client?->id, $ids))
            @else
            @if (auth()->user()->type == 'admin' ||
            auth()->user()->role->hasPermission('units-createContract'))
            <a class="dropdown-item" title="{{ $unit->status == 'taken' ? 'Contract Form' : 'Contract Form' }}" href="{{ route('unitContract', [$unit->id, $unit->client_id]) }}">
                Generate Contract
            </a>
            @endif
            @endif
            @endif
        </div>
    </div>

    <div class="card-body">
        <div class="row">
            {{-- Basic Data --}}
            <div class="col-5">
                <table id="trTable">
                    <tbody>
                        @if ($unit->client)
                        <tr>
                            <th>Client: </th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('clients-show'))
                                <a href="{{ route('clients.show', $unit->client->id) }}">
                                    {{ $unit->client->name }}
                                </a>
                                @else
                                <a>
                                    {{ $unit->client->name }}
                                </a>
                                @endif
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <th>Unit Name: </th>
                            <td>{{ $unit->name ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>{{ $unit->building->phase->project->is_residential == 1 ? 'Building Name' : 'Floor' }}
                            </th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('buildings-show'))
                                <a href="{{ route('buildings.show', $unit->building->id) }}">
                                    {{ $unit->building->name }} -
                                    {{ $unit->building->phase->project->is_residential == 1 ? $unit->building->type : $unit->building->phase->type }}
                                </a>
                                @else
                                <a>
                                    {{ $unit->building->name }} -
                                    {{ $unit->building->phase->project->is_residential == 1 ? $unit->building->type : $unit->building->phase->type }}
                                </a>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Phase Name: </th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('phases-show'))
                                <a href="{{ route('phases.show', $unit->building->phase->id) }}">
                                    {{ $unit->building->phase->name }}
                                </a>
                                @else
                                <a>
                                    {{ $unit->building->phase->name }}
                                </a>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>Project Name: </th>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('projects-show'))
                                <a href="{{ route('projects.show', $unit->building->phase->project->id) }}">
                                    {{ $unit->building->phase->project->name }}
                                </a>
                                @else
                                <a>
                                    {{ $unit->building->phase->project->name }}
                                </a>
                                @endif
                            </td>
                        </tr>
                        @if ($unit->building->phase->project->is_residential == 1)
                        <tr>
                            <th>Floor: </th>
                            <td>{{ $unit->floor == 0 ? 'Ground' : $unit->floor }}</td>
                        </tr>
                        <tr>
                            <th>BedRooms: </th>
                            <td>{{ $unit->bedrooms ?? 0 }}</td>
                        </tr>
                        <tr>
                            <th>BathRooms: </th>
                            <td>{{ $unit->bathrooms ?? 0 }}</td>
                        </tr>
                        <tr>
                            <th>Dressing: </th>
                            <td>{{ $unit->dressing ?? 0 }}</td>
                        </tr>
                        @endif
                        <tr>
                            <th>Unit Space : </th>
                            <td>{{ $unit->unit_space ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>Garden Space :</th>
                            <td>{{ $unit->garden_space ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>Roof Space :</th>
                            <td>{{ $unit->roof_space ?? '' }}</td>
                        </tr>


                        <tr>
                            <th>Unit Type</th>
                            <td>{{ $unit->typee->name ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Unit View</th>
                            <td>{{ $unit->vieww->name ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Finishing Level</th>
                            <td>{{ $unit->finishingLevel->name ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>Description</th>
                            <td>{{ $unit->description ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>Delivery Date :</th>
                            <td>{{ $payment->delivery_date ?? '' }}</td>
                        </tr>

                        <tr>
                            <th>Status</th>
                            <td>{{ $unit->status == 'taken' ? 'Contracted' : $unit->status }}</td>
                        </tr>
                        @if (!empty($unit->client_id))
                        <tr>
                            <th>Booked date :</th>
                            <td>{{ $unit->Booked_date ? $unit->Booked_date : '' }}</td>
                        </tr>
                        @if (!empty($facilities))
                        <tr>
                            <th>Facilities: </th>
                            <td>
                                @for ($i = 0; $i < count($facilities); $i++) <li>{{ $facilities[$i]['name'] }} -
                                    {{ $facilities[$i]['price'] }}L.E</li>
                                    @endfor
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <th>Unit Price "With Facilities" :</th>
                            <td>{{ $payment->total_price ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Mentainance Amount:</th>
                            <td>{{ $payment->mentainance ?? '00' }}</td>
                        </tr>
                        <tr>
                            <th>Total Amount:</th>
                            <td>{{ $payment->total_amount ?? '00' }}</td>
                        </tr>
                        <tr>
                            <th>Remaining:</th>
                            <td>
                                @if (empty($payment->remaining))
                                {{ $payment->remaining <= 0 ? 'Done' : $payment->remaining }}
                                @endif
                            </td>
                        </tr>
                        @endif
                    </tbody>
                </table>
            </div>
            <div class="col-6">
                {{-- Prices --}}
                <table id="original-nonExport" class="display nowrap">
                    <tr>
                        <th>years</th>
                        <th>unit meter price</th>
                        <th>unit price</th>
                        <th>garden price</th>
                        <th>roof price</th>
                        <th>total price</th>
                    </tr>
                    @foreach($unit->prices as $price)
                    @if($unit->project_id == 7)
                    <tr>
                        @if($price->years == '1')
                        @if(auth()->user()->role->hasPermission('units-one-year-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '2')
                        @if(auth()->user()->role->hasPermission('units-two-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '3')
                        @if(auth()->user()->role->hasPermission('units-three-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '4')
                        @if(auth()->user()->role->hasPermission('units-four-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '5')
                        @if(auth()->user()->role->hasPermission('units-five-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '6')
                        @if(auth()->user()->role->hasPermission('units-six-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                        @if($price->years == '8')
                        @if(auth()->user()->role->hasPermission('units-eight-years-price'))
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                        @endif
                        @endif
                    </tr>
                    @else
                    <tr>
                        <td>{{$price->years}}</td>
                        <td>{{$price->meter_price}}</td>
                        <td>{{$price->price}}</td>
                        <td>{{$price->garden_price}}</td>
                        <td>{{$price->roof_price}}</td>
                        <td>{{$price->total_price}}</td>
                    </tr>
                    @endif
                    @endforeach
                    <tr>
                        <td>7</td>
                        <td>{{$unit->unit_meter_price}}</td>
                        <td>{{$unit->unit_meter_price * $unit->unit_space}}</td>
                        <td>{{$unit->garden_total_price}}</td>
                        <td>{{$unit->roof_total_price}}</td>
                        <td>{{$unit->unit_total_price}}</td>
                    </tr>
                </table>

                @if ($unit->status == 'taken')
                {{-- Payments Card --}}
                @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('units-paymentPlan'))
                <!-- Payment Batches -->
                <div class="card collapsed-card card-outline">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title">
                            Payment Plan
                        </h3>
                    </div>

                    <div class="card-body">
                        <a href="{{ route('batches.index', $unit->id) }}" title="View Unit" class="btn btn-danger" style="float:right"><i class="fas fa-file-invoice"></i></a>

                        <a href="{{ route('clients.show', $unit->client->id) }}" title="View client" class="btn btn-info" style="float:right"><i class="fas fa-user"></i></a>

                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>Date</th>
                                    <th>Status</th>
                                    <th>Created by</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($unit->batches as $batch)
                                <?php $temp = explode(' ', $batch->date); ?>
                                <tr>
                                    <td>{{ $batch->title ?? '' }}</td>
                                    <td>{{ $batch->type ?? '' }}</td>
                                    <td>{{ $batch->amount ?? '' }}</td>
                                    <td>
                                        {{ $temp[0] }}
                                    </td>
                                    <td>{{ $batch->status ?? '' }}</td>
                                    <td>{{ $batch->user?->name ?? '' }}</td>

                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif
                {{-- Contracts card --}}
                @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('units-contracts'))
                <div class="card collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title">
                            Contracts
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered ">
                            <thead>
                                <tr>
                                    <th>Contract name</th>
                                    <th>Client id</th>
                                    <th>Client name</th>
                                    <th>Is Delivered ?</th>
                                    <th>Contract Date</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($unit->contracts as $contract)
                                @if (!empty($contract->contract?->name))
                                <tr>
                                    <td>{{ $contract->contract?->name ?? '' }}</td>
                                    <td>{{ $contract->client->id ?? '' }}</td>
                                    <td>{{ $contract->client->name ?? '' }}</td>
                                    <td>{{ $contract->is_delivered == 0 ? 'not yet' : 'delivered' }}
                                    <td>{{ $contract->contract_date ?? '' }}
                                    </td>
                                    <td>
                                        @if ($contract->is_delivered == 0)
                                        <a href="{{ route('ContractDelivered', $contract->id) }}" title="Mark as Delivered" class="btn btn-success">
                                            <i class="fas fa-check"></i>
                                        </a>
                                        @endif
                                        <a href="{{ route('printContract', $contract->id) }}" title="Print Contract" class="btn btn-info">
                                            <i class="fas fa-print"></i>
                                        </a>
                                    </td>
                                </tr>
                                @else
                                <tr>
                                    <td></td>
                                    <td>{{ $contract->client->id ?? '' }}</td>
                                    <td>{{ $contract->client->name ?? '' }}</td>
                                    <td>{{ $contract->contract_date ?? '' }}</td>
                                    <td>{{ $contract->is_delivered == 0 ? 'not yet' : 'delivered' }}
                                    <td></td>
                                </tr>
                                @endif
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                @endif
                @endif
                {{-- Files Card --}}
                @if (count($unit->files) != 0)
                @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('units-files'))
                <div class="card collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Attached Files
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered">
                            @foreach ($unit->files as $file)
                            <tr>
                                <td>
                                    <a href="{{ URL::to('/') }}/files/{{ $file->file }}">{{ $file->file }}-{{ $file->created_at }}</a>
                                </td>
                                <td>
                                    <form method="POST" action="{{ route('files.destroy', $file->id) }}">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-outline-danger">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                    </button>
                                </td>
                            </tr>
                            @endforeach
                        </table>
                    </div>
                </div>
                @endif
                @endif
                {{-- Images Card --}}
                @if (count($unit->images) != 0)
                @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('units-gallery'))
                <div class="card collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Images
                        </h3>
                    </div>
                    <div class="card-body">

                        <div class="col-12 pb-3">
                            <div class="swiper mySwiper my-3" id="mySwiper" data-toggle="modal" data-target="#imageGallery">
                                <div class="swiper-wrapper">
                                    @foreach ($unit->images as $key => $value)
                                    <div class="swiper-slide">
                                        <img class="swiper-slide" src="{{ URL::to('/') }}/images/{{ $value->name }}" alt="{{ $value->name }}" />
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @endif

            </div>
        </div>
    </div>
</div>


<!-- Approve Revoke Modal -->
<div class="modal fade" id="unitDelete" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Discard Record</h5>
            </div>
            <div class="modal-body">
                <h5 class="modal-title">Are u sure u want to discard this unit ?</h5>
            </div>
            <form action="{{ route('changeStatus') }}" method="POST">
                @csrf
                <input name="unit_id" value="{{ $unit->id }}" type="hidden">
                <input name="status" value="revoke" type="hidden">

                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger" type="button">Yes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Hidding Modal -->
<div class="modal fade" id="hidding" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ $unit->is_active == 0 ? 'unhide' : 'hide' }} Unit</h5>
            </div>
            <div class="modal-body">
                <h5 class="modal-title">Are u sure u want to {{ $unit->is_active == 0 ? 'unhide' : 'hide' }} this
                    unit ?</h5>
            </div>
            <form action="{{ route('hideUnit', $unit->id) }}" method="POST">
                @csrf
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-danger" type="button">Yes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- upload files Modal -->
<div class="modal fade" id="uploadFiles" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Upload</h5>
            </div>
            <form action="{{ route('UnitfileUpload') }}" method="POST" enctype="multipart/form-data">
                <div class="modal-body">
                    @csrf
                    @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('units-uplaodImages'))
                    <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                        <i class="fas fa-file-image"></i>
                        Upload Image
                    </label>
                    <input type="file" name="images[]" id="upload-photo" multiple>
                    @endif

                    @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('units-uploadFiles'))
                    <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                        <i class="fas fa-file-pdf"></i>
                        Upload File
                    </label>
                    <input type="file" name="files[]" id="upload-file" multiple>
                    @endif
                    <input type="hidden" value="{{ $unit->id }}" name="unit_id">
                </div>
                <div class="modal-footer">
                    <button type="submit" title="upload" class="btn btn-outline-info"><i class="fas fa-upload"></i>
                        Upload</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Delivery Managment Modal -->
<div class="modal fade" id="delivery" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delivery Managment</h5>
            </div>
            <form action="{{ route('deliveryDate') }}" method="POST">
                <div class="modal-body form-group">
                    @csrf
                    @if ($unit->client_id != null)
                    <input name="payment_id" value="{{ $payment->id }}" type="hidden">
                    <input name="unit_id" value="{{ $unit->id }}" type="hidden">
                    <label for="deliveryDate">Delivery Date:</label>
                    <input name="delivery_date" id="deliveryDate" title="unit delivery date" value="{{ $payment->delivery_date ?? '' }}" type="date" class="form-control" required>
                    <br>
                    @if ($unit->status == 'delivered')
                    <label for="is_delivered" class="form-check-label" style="font-weight:bold;">Delivered</label>
                    @else
                    <label for="is_delivered" class="form-check-label" style="font-weight:bold;">Delivered
                        ?</label>
                    <input type="checkbox" id="is_delivered" class="form-control" name="is_delivered" value="1">
                    @endif
                    @endif
                </div>
                <div class="modal-footer">
                    <button type="submit" title="Set delivery Date" class=" btn btn-outline-info">
                        Submit
                    </button>
                </div>
            </form>

        </div>
    </div>
</div>

<!-- Reservation Managment Modal -->
<div class="modal fade" id="reservation" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Reservation Managment</h5>
            </div>
            <div class="modal-body">
                <h5 class="modal-title">next step</h5>
            </div>
            @if ($unit->client_id != null)
            <form action="{{ route('Reservation.form', $unit->client_id) }}" method="GET">
                @csrf
                <input name="unit_id" value="{{ $unit->id }}" type="hidden">
                @if ($unit->status != 'downpayment' && $unit->status != 'taken')
                <button type="submit" title="Next Step" id="change">
                    <i class="fas fa-angle-double-right"></i>
                </button>
                @endif
            </form>
            @endif
        </div>
    </div>
</div>

<!-- Approve Revoke Modal -->
<div class="modal fade" id="transfareUnit" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Transfare Unit To Another Client</h5>
            </div>
            <form action="{{ route('transfareUnit') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="form-group">
                        <label>Clients</label>
                        <select name='client_id' class="select2 custom-select form-control-border">
                            @foreach ($clients as $client)
                            <option {{ $client->id == $unit->client?->id ? 'selected' : '' }} value="{{ $client->id }}">
                                {{ $client->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <input name="unit_id" value="{{ $unit->id }}" type="hidden">

                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info" type="button">Yes</button>
                </div>
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="image" role="dialog" aria-labelledby="image" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Delete Record</h5>
            </div>
            <div class="modal-body">
                <p>Are you sure to delete this Image ?</p>
            </div>
            <form class="modal-footer" method="post">
                @csrf
                @method('DELETE')
                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
            </form>
        </div>
    </div>
</div>

<!-- gallery Image from Slider Modal -->
<div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: unset;box-shadow: unset;border: unset;">
            <div class="modal-body">
                <div class="swiper2 mySwiper2">
                    <div class="swiper-wrapper">
                        @foreach ($unit->images as $key => $value)
                        <div class="swiper-slide">
                            <img style="position: absolute" src="{{ URL::to('/') }}/images/{{ $value->name }}" alt="{{ $value->name }}" />
                            <a href="{{ route('unit.deleteImage', $value->id) }}">
                                <button style="position: relative; float:right;color:white;font-size:30px" class="btn">×</button>
                            </a>
                        </div>
                        @endforeach
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="module" src="{{ asset('swiper/swiper.js') }}"></script>

<script>
    $("#status").change(function() {
        var data = this.value;
        if (data == 'taken') {
            $("#contract").show();
            $("#change").hide();

        } else {
            $("#contract").hide();
            $("#change").show();

        }
    });

    clickDelete = (e) => {
        const modelId = e.getAttribute("data-id");
        var route = "{{ route('galleries.destroy', ':id') }}";
        route = route.replace(':id', modelId);
        $('#image').find($('form')).attr('action', route);
    }
</script>


@endsection