<!DOCTYPE html>
<html lang="ar">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservation Report</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            direction: rtl;
            text-align: right;
            margin: 0;
            padding: 20px;
            box-sizing: border-box;
        }

        .container {
            width: 100%;
            max-width: 1000px;
            margin: 0 auto;
            padding: 20px;
            border: 1px solid black;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table,
        th,
        td {
            border: 1px solid black;
            padding: 3px;
        }

        th,
        td {
            text-align: right;
        }

        .header-table {
            width: 40%;
            border-spacing: 20px;
            margin-bottom: 20px;
            flex-basis: 450px;
            flex-grow: 0;
        }

        .header-table td {
            width: 50%;
            border: 1px solid black;
            padding: 2px;
            text-align: center;
        }

        .section-title {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .center-text {
            text-align: center;
        }

        .print-button {
            text-align: center;
            margin-top: 20px;
        }

        .print-button button {
            padding: 10px 20px;
            font-size: 16px;
            cursor: pointer;
        }

        .row {
            display: flex;
            justify-content: space-between;
            flex-wrap: wrap;
        }

        .btn {
            display: inline-block;
            font-weight: 400;
            color: #212529;
            text-align: center;
            vertical-align: middle;
            -webkit-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
            background-color: transparent;
            border: 1px solid transparent;
            padding: .375rem .75rem;
            font-size: 1rem;
            line-height: 1.5;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out, border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }

        .btn-light {
            color: #1f2d3d;
            background-color: #dae0e5;
            border-color: #d3d9df;
        }

        .btn-success {
            color: #fff;
            background-color: #28a745;
            border-color: #28a745;
            box-shadow: none;
        }

        @media print {
            .header-table {
                flex-basis: 300px;
            }

            .print-button {
                display: none;
            }
        }
    </style>
</head>

<body>

    <div class="container">

        <!-- Header Section with Individual Tables for Each Label and Value -->
        <div class="row">
            <table class="header-table">
                <tr>
                    <th>التاريخ</th>
                    <td> {{ $unit->installments[0]->contract_date }} </td>
                </tr>
            </table>

            <table class="header-table">
                <tr>
                    <th>اليوم</th>
                    <td>{{ $unit->installments[0]->contract_day }}</td>

                </tr>
            </table>

        </div>

        <table class="header-table" style="width:75%">
            <tr>
                <th>اسم العميل</th>
                <td> {{ $unit->client->name }}</td>
            </tr>
        </table>

        <div class="row">
            <table class="header-table">
                <tr>
                    <th>مساحة الوحدة</th>
                    <td>{{ $unit->unit_space }}</td>
                </tr>

            </table>

            <table class="header-table">
                <tr>
                    <th>رقم الوحدة</th>
                    <th>الدور</th>
                </tr>
                <tr>
                    <td>{{ $unit->name }}</td>
                    <td> {{ $unit->floor == 0 ? 'Ground' : $unit->floor }}</td>
                </tr>
            </table>
        </div>


        <div class="row">
            <table class="header-table">
                <tr>
                    <th> اجمالى سعر الوحدة </th>
                    <td>{{ $unit->payment->total_price }}</td>
                </tr>
            </table>

            <table class="header-table">

                <tr>
                    <th>التشطيب</th>
                    <td> {{ $unit->finishingLevel->name }} </td>
                </tr>
            </table>
        </div>

        <div class="row">
            <table class="header-table">
                <tr>
                    <th>دفعة التعاقد</th>
                    <td> {{ $unit->payment->down_payment }} </td>
                </tr>
            </table>

            <table class="header-table">
                <tr>
                    <th>اجمالى الاقساط المتبقية</th>
                    <td>{{ $unit->payment->remaining - $unit->payment->mentainance }}</td>
                </tr>
            </table>
        </div>

        <table class="header-table" style="width:75%">
            <tr>
                <th>مجموع اقساط وديعه الصيانة</th>
                <td>{{ $unit->payment->mentainance }}</td>
            </tr>
        </table>

        <!-- Title -->
        <div class="section-title">جدول الأقساط الخاصة بالوحدة والصيانة</div>

        <!-- Main Table -->
        <table>
            <thead>
                <tr>
                    <th>رقم القسط</th>
                    <th>التاريخ</th>
                    <th>المبلغ</th>
                    <th>الرصيد</th>
                    <th>حالة الدفع</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($unit->installments as $installment)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $installment->due_date }}</td>
                        <td>{{ number_format($installment->amount, 2) }} EGP</td>
                        <td>{{ number_format($installment->remaining_balance, 2) }} EGP</td>
                        <td>
                            @if ($installment->is_paid)
                                مدفوع
                            @else
                                غير مدفوع
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <!-- Total Summary Section -->
        <div class="row">

            <table class="header-table">
                <tr>
                    <td>مجموع أقساط ودية الصيانة</td>
                    <td>246,848</td>
                </tr>
            </table>
            <table class="header-table">
                <tr>
                    <td>اجمالى الاقساط المتبقية على الوحدة</td>
                    <td>2,248,480</td>
                </tr>
            </table>
        </div>

        <!-- Print Button -->
        <div class="print-button">
            <button class="btn btn-success" onclick="window.print()">Print</button>
            <a href="{{ route('dashboard') }}">
                <button class="btn btn-light"> Back</button>
            </a>
        </div>
    </div>

</body>

</html>
