@extends ('../welcome')
@section('content')
    <!-- /.row -->
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Units</h3><br>
            <p>Total: {{ count($units) }}</p>

            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-restoreAll'))
                <a href="{{ route('units.restoreAll') }}" title="Restore All" style="float:right">
                    <button class="btn btn-square btn-outline-success" type="button"><i
                            class="fas fa-trash-restore-alt"></i></button>
                </a>
            @endif

        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('units-archive-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered ">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Building</th>

                        <th>phase</th>
                        <th>Building Type</th>
                        <th>Project</th>
                        <th>Total Price</th>
                        <th>Total Space</th>
                        <th>Floor</th>
                        <th>Bedroom</th>
                        <th>Garden Space</th>
                        <th>Bathrooms</th>
                        <th>Roof Space</th>

                        <th>booked date</th>
                        <th>Client</th>
                        <th>Sales Man</th>
                        <th>status</th>

                        <th>Created Date</th>
                        <th>Created Time</th>

                        <th>Active</th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($units as $unit)
                        <?php $temp = explode(' ', $unit->created_at->setTimezone('Africa/Cairo')); ?>

                        @if (empty($unit->building->phase->project->id))
                        @else
                            <tr class='clickable-row' data-href='{{ route('units.show', $unit->id) }}'>
                                <td> {{ $unit->name }} </td>
                                <td> {{ $unit->building->phase->name }} </td>
                                <td> {{ $unit->building->name ?? '' }} </td>
                                <td>{{ $unit->building?->type ?? '' }}</td>
                                <td> {{ $unit->building?->phase?->project?->name ?? '' }} </td>
                                <td>{{ $unit->unit_total_price ?? '' }}</td>
                                <td>{{ $unit->unit_space ?? '' }}</td>
                                <td>{{ $unit->floor ?? '' }}</td>
                                <td>{{ $unit->bedrooms ?? '' }}</td>
                                <td style="color: {{ $unit->garden_space ? '' : 'red' }}">
                                    {{ $unit->garden_space ? $unit->garden_space : 'No Garden For this Unit' }}
                                </td>
                                <td>{{ $unit->bathrooms }}</td>
                                <td>{{ $unit->building->roof_space }}</td>

                                <td>{{ $unit->Booked_date ?? '' }}</td>
                                <td>{{ $unit->client->name ?? '' }}</td>
                                <td>{{ $unit->user->name ?? '' }}</td>
                                <td>{{ $unit->status ?? '' }}</td>

                                <td>{{ $temp[0] ?? '' }}</td>
                                <td>{{ $temp[1] ?? '' }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-restore'))
                                        <a class="btn btn-outline-light" title="Restore"
                                            href="{{ route('unitsRestore', $unit->id) }}">
                                            <i class="fas fa-trash-restore-alt"></i>
                                        </a>
                                    @endif
                                </td>
                            </tr>
                        @endif
                    @endforeach
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
    <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });
    </script>
@endsection
