@extends ('../welcome')


@section ('content')

<div class="card card-info">
    <div class="card-header">
        <h3 class="card-title">Assign User</h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">
        <form action="{{ route('tickets.update', $ticket->id) }}" method="post">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->
                    <div class="form-group">
                    <label>Title</label>
                        <input type="text" name="title" class="form-control" value="{{$ticket->title}}" disabled>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->
                    <div class="form-group">
                        <label>Description</label>
                        <input id='Description' name="description" class="form-control" value="{{$ticket->description}}" disabled>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->
                    <div class="form-group">
                        <select name="user_id" class="form-control">
                            @foreach ($users as $user)
                            <option value="{{$user->id}}">{{$user->name}}</option>
                            @endforeach
                        </select>

                    </div>
                </div>
            </div>
            

            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Submit</button>
            </div>
        </form>
    </div>
    <!-- /.card-body -->
</div>

@endsection