@extends ('../welcome')


@section('content')
    <div class="card col-12">
        <div class="card-header">
            <h4 class="card-title"><strong>Trashed Roles</strong></h4>
            <br>
            <lable><span style="font-size:18px;font-weight:bold">Total: </span> {{ count($roles) }}</lable>

            @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('roles-restoreAll'))
                <div style="float:right;" title="Restore All">
                    <a href="{{ route('roles.restoreAll') }}" class="btn btn-success"><i class="fas fa-trash-restore"></i></a>
                </div>
            @endif
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table class="table table-responsive display" id="example1">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Description</th>
                        <th>Belongs to</th>
                        <th>Deleted at</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($roles as $role)
                        <tr>
                            <td>{{ $role->id }}</td>
                            <td>
                                {{ $role->display_name }}
                            </td>
                            <td>{{ $role->description }}</td>
                            <td>{{ $role->parent?->name }}</td>
                            <td>{{ $role->deleted_at }}</td>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('roles-restore'))
                                    <a class="btn btn-success" title="Restore Role"
                                        href="{{ route('roles.restore', $role->id) }}">
                                        <i class="fas fa-trash-restore"></i>
                                    </a>
                                @endif

                                {{-- @if (auth()->user()->role->hasPermission('phases-delete')) --}}
                                {{-- <a class="btn btn-warning" title="Show" href="{{ route('roles.show', $role->id) }}">
                                    <i class="fa fa-eye"></i>
                                </a> --}}
                                {{-- @endif --}}

                                {{-- @if (auth()->user()->role->hasPermission('delete-permanently')) --}}
                                    <a href="{{ route('roles.deletePermanently', $role->id) }}">
                                        <button title="Delete" class="btn btn-danger">
                                            <i class="fa fa-ban"></i>
                                        </button>
                                    </a>
                                {{-- @endif --}}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
@endsection
