@extends ('../welcome')
@section('content')
    <link rel="stylesheet" href="{{ asset('swiper/swiper.css') }}">


    <style>
        #upload-photo {
            display: none;
        }

        #upload-file {
            display: none;
        }

        #carouselExampleControls .btn {
            position: absolute;
            top: 0%;
            right: 0%;
            background-color: transparent;

            opacity: 0.5;
            color: white;
            border: none;
            cursor: pointer;
            border-radius: 5px;
            color: grey;


        }

        .w-100 {
            height: 400px !important
        }

        #carouselExampleControls .btn:hover {
            background-color: transparent;
            opacity: 3.0;
            color: white;
        }

        /* swiper ////////////////////////////////////*/
        .swiper {
            width: 240px;
            height: 320px;
        }

        .swiper .swiper-slide {
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 18px;
            font-size: 22px;
            font-weight: bold;
            color: #fff;
        }

        .swiper2 {
            width: 100%;
            padding-top: 50px;
            padding-bottom: 50px;
        }

        .swiper2 .swiper-slide {
            background-position: center;
            background-size: cover;
            width: 300px;
            height: 300px;
        }

        .swiper2 .swiper-slide img {
            display: block;
            width: 100%;
        }
    </style>

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-4">
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-edit'))
                        <a href="{{ route('projects.edit', $project->id) }}">
                            <button class="btn btn-square btn-info" type="button"><i class="fas fa-pen"></i></button>
                        </a>
                    @endif

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-delete'))
                        @if (count($project->campaigns) == 0 && count($project->phases) == 0)
                            <button onClick="clickDeletebutton(this)" title="Delete" style="height:38px;"
                                class="btn btn-danger" data-id="{{ $project->id }}" data-toggle="modal"
                                data-target="#projectModals">
                                <i class="fa fa-ban"></i>
                            </button>
                        @endif
                    @endif

                </div>
                <form action="{{ route('ProjectfileUpload') }}" method="POST" enctype="multipart/form-data" class="col-7">
                    @csrf

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-uploadImages'))
                        <label for="upload-photo" class="btn btn-outline-success" title="upload image">
                            <i class="fas fa-file-image"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="images[]" id="upload-photo" multiple>
                    @endif

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-uploadFiles'))
                        <label for="upload-file" class="btn btn-outline-danger" title="attach files">
                            <i class="fas fa-file-pdf"></i> &nbsp;
                            <i class="fas fa-upload"></i>
                        </label>
                        <input type="file" name="files[]" id="upload-file" multiple>
                    @endif


                    <input type="hidden" value="{{ $project->id }}" name="project_id">

                    <button type="submit" title="upload" style="margin-bottom:10px;" class="btn btn-outline-info"><i
                            class="fas fa-check"></i></button>
                </form>
            </div>
            {{-- @if (auth()->user()->type == 'admin' ||
    auth()->user()->role->hasPermission('projects-hide'))
                    <form action="{{ route('hideProject', $project->id) }}" method="POST">
                        @csrf
                        <button type="submit"
                            class="btn btn-outline-{{ $project->is_active == 0 ? 'light' : 'dark' }} active"
                            title="{{ $project->is_active == 0 ? 'unhide' : 'hide' }}">
                            <i class="fas fa-{{ $project->is_active == 0 ? 'eye' : 'eye-slash' }}"></i>
                        </button>
                    </form>
                @endif --}}

        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-6">
                <table>
                    <tr>
                        <th>Project ID :</th>
                        <td>{{ $project->id ?? '' }}</td>
                    </tr>
                    <tr>
                        <th>Project Name :</th>
                        <td>{{ $project->name ?? '' }}</td>
                    </tr>
                    <tr>
                        <th>Description :</th>
                        <td>{{ $project->description ?? '' }}</td>
                    </tr>
                    <tr>
                        <th>Mentainance :</th>
                        <td>{{ $project->mentainance ?? 0 }}</td>
                    </tr>
                    <tr>
                        <th>Active :</th>
                        <td>{{ $project->is_active == 0 ? 'Not Available' : 'Available' }}</td>
                    </tr>
                    <tr>
                        <th>Type :</th>
                        <td>{{ $project->is_residential == 0 ? 'Not Residential' : 'Residential' }}</td>
                    </tr>
                    <tr>
                        <th>Created at :</th>
                        <td>{{ $project->created_at }}</td>
                    </tr>

                </table>
                <hr>

            </div>
            <div class="col-6">
                {{-- Facilities --}}
                <div class="card collapsed-card card-outline">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Facilities
                        </h3>

                    </div>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-facilities'))
                        <div class="card-body">
                            <table>
                                @foreach ($project->facilities as $facility)
                                    <tr>
                                        <td>*{{ $facility->name }} </td>
                                    </tr>
                                @endforeach
                            </table>
                        </div>
                    @endif
                </div>

                {{-- Accessed Users --}}
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Accessed Users
                        </h3>

                    </div>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-accessedUsers'))
                        <div class="card-body">
                            <table>
                                @forelse($project->users as $user)
                                    <tr>
                                        <td title="{{ $user->role->name }}">
                                            <a href="{{ route('users.show', $user->id) }}">
                                                {{ $user->name }}
                                            </a>
                                        </td>
                                    </tr>
                                @empty
                                @endforelse
                            </table>
                        </div>
                    @endif
                </div>
                {{-- Campaigns --}}
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Campaigns
                        </h3>

                    </div>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-campaigns'))
                        <div class="card-body">
                            @forelse ($project->campaigns as $campaign)
                                <a href="{{ route('campaigns.show', $campaign->id) }}">
                                    <label class="">*{{ $campaign->name }}: </label>
                                </a>
                                <label class=""> {{ $campaign->created_at }}</label><br>
                            @empty
                            @endforelse
                        </div>
                    @endif
                </div>
                {{-- Attached Files --}}
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Attached Files
                        </h3>
                    </div>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-files'))
                        <div class="card-body">
                            @forelse ($project->files as $file)
                                <tr>
                                    <td>
                                        <a href="{{ URL::to('/') }}/files/{{ $file->file }}">
                                            {{ $file->file }}-{{ $file->created_at }}
                                        </a>
                                    </td>
                                </tr>
                            @empty
                            @endforelse
                        </div>
                    @endif
                </div>
                {{-- Gallery --}}
                <div class="card card-outline collapsed-card">
                    <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                        <h3 class="card-title" style="font-weight:bold;">
                            Gallery
                        </h3>
                    </div>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('projects-gallery'))
                        <div class="card-body">
                            <div class="swiper mySwiper" id="mySwiper" data-toggle="modal" data-target="#imageGallery">
                                <div class="swiper-wrapper">
                                    @foreach ($project->images as $key => $value)
                                        <div class="swiper-slide">
                                            <img class="swiper-slide" src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                                alt="{{ $value->name }}" />
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="card-footer">
        {{-- Phases --}}
        @if (auth()->user()->type == 'admin' ||
                auth()->user()->role->hasPermission('phases-read'))
            <div class="card card-outline ">
                <div class="card-header">
                    <h3 class="card-title" style="font-weight:bold;font-size:23px;">Phases<br>
                        <p>Total: {{ count($phases) }}</p>
                    </h3>

                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('phases-create'))
                        <a href="{{ route('phases.create', 'id=' . $project->id) }}" style="float:right">
                            <button class="btn btn-square btn-light active" type="button"><i
                                    class="fas fa-plus"></i></button>
                        </a>
                    @endif

                </div>
                <div class="card-body">
                    <table class=" table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Name</th>
                                @if ($project->is_residential == 0)
                                    <th>Type</th>
                                @endif
                                <th>Availability</th>
                                <th>Created Date</th>
                                <th>Created Time</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($phases as $phase)
                                <?php $temp = explode(' ', $phase->created_at->setTimezone('Africa/Cairo')); ?>

                                <td>{{ $phase->id }}</td>
                                <td>
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('phases-show'))
                                        <a href="{{ route('phases.show', $phase->id) }}">
                                            {{ $phase->name }}
                                        </a>
                                    @else
                                        {{ $phase->name }}
                                    @endif
                                </td>
                                @if ($project->is_residential == 0)
                                    <td>{{ $phase->type ?? '' }}</td>
                                @endif
                                <td>{{ $phase->is_active == 0 ? 'Not Available' : 'Available' }}</td>
                                <td>{{ $temp[0] ?? '' }}</td>
                                <td>{{ $temp[1] ?? '' }}</td>
                                <td style="text-align:center;">
                                    @if (auth()->user()->type == 'admin' ||
                                            auth()->user()->role->hasPermission('phases-edit'))
                                        <a class="btn btn-info" title="Edit"
                                            href="{{ route('phases.edit', $phase->id) }}">
                                            <i class="fa fa-pen"></i>
                                        </a>
                                    @endif
                                </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        @endif
        {{-- End Phases --}}
    </div>
    </div>

    {{-- Delete Project Modal --}}
    <div class="modal fade" id="projectModals" tabindex="-1" role="dialog" aria-labelledby="projectModals"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    @if (count($project->phases) == 0)
                        <p>Are you sure to delete this record ?</p>
                    @else
                        <p>this project has phases you can't delete this project</p>
                    @endif
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    @if (count($project->phases) == 0)
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    @endif
                </form>
            </div>
        </div>
    </div>

    {{-- Delete Images Modal --}}
    <div class="modal fade" id="image" tabindex="-1" role="dialog" aria-labelledby="image" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this Image ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <!-- gallery Image from Slider Modal -->
    <div class="modal fade" id="imageGallery" aria-modal="true" role="dialog">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content"
                style="background-color: unset;
                        box-shadow: unset;
                        border: unset;">
                <div class="modal-body">
                    <div class="swiper2 mySwiper2">
                        <div class="swiper-wrapper">
                            @foreach ($project->images as $key => $value)
                                <div class="swiper-slide">
                                    <img style="position: absolute" src="{{ URL::to('/') }}/images/{{ $value->name }}"
                                        alt="{{ $value->name }}" />
                                    <button style="position: relative; float:right;color:white;font-size:30px"
                                        class="btn">×</button>
                                </div>
                            @endforeach
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script type="module" src="{{ asset('swiper/swiper.js') }}"></script>
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('projects.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#projectModals').find($('form')).attr('action', route);
        }

        clickDelete = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('galleries.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#image').find($('form')).attr('action', route);
        }

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('phases.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#phaseModals').find($('form')).attr('action', route);
        }
    </script>
@endsection
