@extends ('../welcome')
@section('content')
    <style>
        .clickable-row:hover {
            background-color: #17a2b8;
            opacity: 0.8;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        th {
            width: 40%;
        }
    </style>
    <div class="card col-6">
        <div class="card-header">

            <form action="{{ route('hidePhase', $phase->id) }}" method="POST">
                @csrf


                {{-- @if (auth()->user()->role->hasPermission('phases-update')) --}}
                <a href="{{ route('phases.edit', $phase->id) }}">
                    <button class="btn btn-square btn-info" type="button"><i class="fa fa-pen"></i></button>
                </a>
                {{-- @endif --}}

                {{-- @if (auth()->user()->role->hasPermission('phases-delete')) --}}
                <button onClick="clickDeletebutton(this)" type="button" title="Delete" class="btn btn-danger"
                    data-id="{{ $phase->id }}" data-toggle="modal" data-target="#phaseModal">
                    <i class="fa fa-ban"></i>
                </button>
                {{-- @endif --}}

                <button type="submit" style="float:right"
                    class="btn btn-{{ $phase->is_active == 0 ? 'light' : 'dark' }} active"
                    title="{{ $phase->is_active == 0 ? 'unhide' : 'hide' }}">
                    <i class="fas fa-{{ $phase->is_active == 0 ? 'eye' : 'eye-slash' }}"></i>
                </button>

            </form>


        </div>
        <div class="card-body">
            <table>
                <tr>
                    <th>Phase Name:</th>
                    <td>{{ $phase->name }}</td>
                </tr>
                <tr>
                    <th>Project Name:</th>
                    <td>{{ $phase->project->name }}{{ $phase->project->is_residential == 1 ? ' - Residential' : '' }}</td>
                </tr>
                @if ($phase->project->is_residential == 0)
                    <tr>
                        <th>Type</th>
                        <td>{{ $phase->type ?? '' }}</td>
                    </tr>
                @endif
                <tr>
                    <th>Active:</th>
                    <td>{{ $phase->is_active == 0 ? 'Not Available' : 'Available' }}</td>
                </tr>
                <tr>
                    <th>Created at :</th>
                    <td>{{ $phase->created_at }}</td>
                </tr>
                @if(auth()->user()->type == 'admin')
                <tr>
                    <th>Accessed By :</th>
                </tr>
                @foreach ($phase->users as $user)
                    <tr>
                        <th></th>
                        <td>
                            <a href="{{ route('users.show', $user->id) }}">
                                {{ $user->name }}
                            </a>
                        </td>
                    </tr>
                @endforeach
                @endif
            </table>
        </div>
    </div>
    {{-- @if (auth()->user()->role->hasPermission('buildings-read')) --}}
    <div class="col-12">
        <div class="card card-outline card-info">
            <div class="card-header">
                <h3 class="card-title" style="font-weight:bold">
                    {{ $phase->project->is_residential == 1 ? 'building' : 'Floor' }}
                    <p>Total: {{ count($phase->buildings) }}</p>
                </h3>

                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('buildings-create'))
                    <a href="{{ route('buildings.create', 'id=' . $phase->id) }}">
                        <button class="btn btn-square btn-light active"
                            title="{{ $phase->project->is_residential == 1 ? 'Create Building' : 'Create Floor' }}"
                            style="float:right" type="button"><i class="fas fa-plus"></i></button>
                    </a>
                @endif
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <table
                    id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('buildings-export')? 'example1': 'nonExport' }}
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>

                            @if ($phase->project->is_residential == 1)
                                <th>Building Type</th>
                                <th>Number of Floors</th>
                            @endif

                            <th>Created Date</th>
                            <th>Created Time</th>

                            @if (auth()->user()->type == 'admin')
                                <th>Visibility</th>
                            @endif
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($phase->buildings as $building)
                            <?php $temp = explode(' ', $building->created_at->setTimezone('Africa/Cairo')); ?>
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('buildings-show'))
                                <tr class='clickable-row' data-href='{{ route('buildings.show', $building->id) }}'>
                                @else
                                <tr>
                            @endif
                            <td>{{ $building->id }}</td>
                            <td>{{ $building->name }}</td>

                            @if ($building->phase->project->is_residential == 1)
                                <td>{{ $building->type }}</td>
                                <td>{{ $building->number_of_floors }}</td>
                            @endif
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('buildings-hide'))
                                    <form action="{{ route('hideBuilding', $building->id) }}" method="POST">
                                        @csrf
                                        @if (auth()->user()->type == 'admin')
                                            <button type="submit"
                                                class="btn btn-{{ $building->is_active == 0 ? 'light' : 'dark' }}"
                                                title="{{ $building->is_active == 0 ? 'unhide' : 'hide' }}">
                                                <i
                                                    class="fas fa-{{ $building->is_active == 0 ? 'eye' : 'eye-slash' }}"></i>
                                            </button>
                                        @endif
                                    </form>
                                @endif
                            </td>
                            <td>
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('buildings-edit'))
                                    <a class="btn btn-info" title="Edit"
                                        href="{{ route('buildings.edit', $building->id) }}">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                @endif
                            </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <th></th>
                            <th></th>

                            @if ($phase->project->is_residential == 1)
                                <th></th>
                                <th></th>
                            @endif

                            <th></th>
                            <th></th>

                            @if (auth()->user()->type == 'admin')
                                <th></th>
                            @endif
                            <th></th>
                        </tr>
                    </tfoot>
                </table>

            </div>
        </div>
    </div>
    {{-- @endif --}}
    <div class="modal fade" id="phaseModal" tabindex="-1" role="dialog" aria-labelledby="phaseModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    @if (count($phase->buildings) == 0)
                        <p>Are you sure to delete this record ?</p>
                    @else
                        <p>this Phase has Buildings you can't delete this Phase</p>
                    @endif
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    @if (count($phase->buildings) == 0)
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    @endif
                </form>
            </div>
        </div>
    </div>



    <!-- /.row -->
    <script>
        jQuery(document).ready(function($) {
            $(".clickable-row").click(function() {
                window.location = $(this).data("href");
            });
        });

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('phases.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#phaseModal').find($('form')).attr('action', route);
        }
    </script>
@endsection
