@extends ('../welcome')


@section('content')


    <!-- /.row -->
    <div class="col-12">
        <div class="card">
            {{-- <div class="card-header">
                <h4 class="card-title"><strong>Select User</strong></h3>
                    <div class="col-md-2">
                        <select name="user" id="selectedUser" class="custom-select form-control-border">
                            <option value="">--</option>
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">
                                    {{ $user->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
            </div> --}}

            <div class="card-header">
                <h4 class="card-title"><strong>Select Role</strong></h3>
                    <div class="col-md-2">
                        <select name="role" id="selectedRole" class="custom-select form-control-border">
                            <option value="">--</option>
                            @foreach ($roles as $role)
                                <option value="{{ $role->id }}">
                                    {{ $role->name }}
                                </option>
                            @endforeach
                        </select>
                    </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body table-responsive p-0">
                <table class="table table-head-fixed text-nowrap">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Action</th>
                            <th>
                                <button onclick="toggleSelectAll()" class="btn" id="selectAll"> Select All </button>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($permissions->groupBy('type') as $type => $permissionsByType)
                            <tr>
                                <td>{{ $type }}</td>
                                <td id="{{ $type }}">
                                    <div style="display: inline;float: right;">
                                        <button class="btn" value="{{ $type }}" id="selectAllSection"> Select All
                                        </button>
                                    </div>
                                    @php
                                        $count = 0;
                                    @endphp
                                    @foreach ($permissionsByType as $permission)
                                        @if ($count % 4 == 0 && $count > 0)
                                            <br>
                                        @endif

                                        <label for={{ $permission['name'] }}>{{ $permission['name'] }}</label>
                                        <input type="checkbox" class="permission-checkbox shadow m-2"
                                            id={{ $permission['name'] }} name="permissions"
                                            value="{{ $permission['id'] }}" />

                                        @php
                                            $count++;
                                        @endphp
                                    @endforeach
                                </td>
                            </tr>
                        @endforeach
                        <tr>
                            <td style="border:unset">
                                <button class="btn btn-primary" id="submitPermission" type="submit">Submit</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <!-- /.card-body -->
        </div>
        <!-- /.card -->
    </div>
    <!-- /.row -->



    <script>
        let selectedAllType = document.querySelectorAll('#selectAllSection');
        let selectAllSection = document.getElementById('selectAllSection');

        selectedAllType.forEach(element => {
            element.addEventListener('click', (type) => {
                let selectedType = document.getElementById(type.target.value).getElementsByTagName('input');
                var isAllChecked = true;
                for (var i = 0; i < selectedType.length; i++) {
                    if (!selectedType[i].checked) {
                        isAllChecked = false;
                        break;
                    }
                }

                for (var i = 0; i < selectedType.length; i++) {
                    selectedType[i].checked = !isAllChecked;
                }
            });
        })

        function toggleSelectAll() {
            var checkboxes = document.querySelectorAll('input[type="checkbox"]');
            var isAllChecked = true;
            for (var i = 0; i < checkboxes.length; i++) {
                if (!checkboxes[i].checked) {
                    isAllChecked = false;
                    break;
                }
            }

            for (var i = 0; i < checkboxes.length; i++) {
                checkboxes[i].checked = !isAllChecked;
            }
        }
    </script>
@endsection
