@extends ('../welcome')


@section('content')
<form action="{{route('paymentPlans.update', $paymentPlan->id)}}" method="post" class="col-6">
    @csrf
    @method('PUT')
    <div class="card card-default">
        <div class="card-body">
            <div class="row">
                <div class="form-group col-3">
                    <label>Title</label>
                    <input type="text" name="title" class="form-control" value="{{$paymentPlan->name}}" required>
                </div>
                <div class="form-group col-3">
                    <label>% or Value</label>
                    <select name="c_method" class="custom-select">
                        <option value="percentage" {{$paymentPlan->c_method == 'percentage' ? 'selected' : ''}}>%
                        </option>
                        <option value="value" {{$paymentPlan->c_method == 'value' ? 'selected' : ''}}>value</option>
                    </select>
                </div>
                <div class="form-group col-3">
                    <label>Type</label>
                    <select name="type" placeholder="Type" class="select2 custom-select form-control-border">
                        <option value="total_unit" {{$paymentPlan->type == 'total_unit' ? 'selected' : ''}}>Total Unit
                        </option>
                        <option value="maintenance" {{$paymentPlan->type == 'maintenance' ? 'selected' : ''}}>
                            Maintenance</option>
                    </select>
                </div>
                <button id="addRow" title="add Type" type="button" class="btn btn-info"
                    style="margin-left: 20px; margin-top:32px;width:20%px;height:20%;">
                    <i class="fas fa-plus"></i>
                </button>
            </div>
            @foreach($paymentPlan->PaymentPlanDetails as $details )

            <div id="inputFormRow">
                <div class="row">
                    <div class="form-group col-4">
                        <select name="payment_type_id[]" placeholder="Payment Type"
                            class="select2 custom-select form-control-border">
                            @foreach($paymentTypes as $type)
                            <option value="{{$type->id}}" {{$details->payment_type_id  == $type->id ? 'selected' : ''}}>
                                {{$type->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group col-2">
                        <input type="number" name="amount[]" value="{{$details->amount}}" class="form-control" required>
                    </div>
                    <div class="form-group col-2">
                        <input type="number" name="batch[]" value="{{$details->batch}}" class="form-control" required>
                    </div>
                    <div class="form-group col-2">
                        <input type="number" name="count[]" value="{{$details->count}}" class="form-control" required>
                    </div>
                    <div class="col-1">
                        <button id="removeRow" type="button" class="btn btn-danger">
                            <i class="fas fa-trash-alt"></i>
                        </button>
                    </div>
                </div>
               
                
            </div>
            @endforeach
            <div id="newRow"></div>
            <div class="col-10" style="display:flex;justify-content:center;">
                <button type="submit" class="btn btn-info" style="width: 33%; margin-top:20px;">Submit</button>
            </div>
        </div>
    </div>
</form>
<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
<script type="text/javascript">
// add row
$("#addRow").click(function() {
    var html = '';
    html += `
    <div id="inputFormRow">
        <div class="row">
            <div class="form-group col-4">
                <select name="payment_type_id[]" class="select2 custom-select form-control-border">
                    @foreach($paymentTypes as $type)
                    <option value="{{$type->id}}">{{$type->name}}</option>
                    @endforeach
                </select>
            </div>

            <div class="form-group col-2">
                <input type="number" name="amount[]" class="form-control" placeholder="00" required>
            </div>
            <div class="form-group col-2">
                <input type="number" name="batch[]" class="form-control" placeholder="00" required>
            </div>
            <div class="form-group col-2">
                <input type="number" name="count[]" class="form-control" placeholder="00" required>
            </div>
            <div class="col-1">
                <button id="removeRow" type="button" class="btn btn-danger">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

    $('#newRow').append(html);
});

// remove row
$(document).on('click', '#removeRow', function() {
    $(this).closest('#inputFormRow').remove();
});
</script>
@endsection