@extends ('../welcome')


@section ('content')

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">

                <div class="timeline-item">
                    <h8 class="timeline-header no-border"> <span style="font-weight: bold;">Client ID:</span>
                        {{$client->id}}</h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Client Name:</span>
                        <a href="{{route('clients.show',$client->id)}}"> {{$client->name}}</a>
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Main Payment Method:</span>
                         {{$client->payment_method}}
                    </h8><br>
                    <h8 class="timeline-header no-border"><span style="font-weight: bold;">Main Payment Details:</span>
                         {{$client->payment_details}}
                    </h8>
                </div>

                {{-- <div class="card-tools">
                    <div class="input-group input-group-sm" style="width: 150px;">
                        <div class="dropdown">
                            <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                Status
                            </button>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                <a class="dropdown-item" href="{{route('payment.index', 'status=all')}}">All</a>
                <a class="dropdown-item" href="{{route('payment.index', 'status=unPaid')}}">Un Paid</a>
                <a class="dropdown-item" href="{{route('payment.index', 'status=inProgress')}}">In
                    Progress</a>
                <a class="dropdown-item" href="{{route('payment.index', 'status=Paid')}}">Paid</a>
            </div>
        </div>
    </div>
</div>
--}}
</div>
<!-- /.card-header -->
<div class="card-body table-responsive p-0" style="height: 300px;">
    <table class="table table-head-fixed text-nowrap">
        <thead>
            <tr style="text-align: center">
                <th>ID</th>
                <th>Title</th>
                <th>Status</th>
                <th>Total Amount</th>
                <th>Created at</th>
                <th>Last Update</th>
                <th>create Transaction</th>
            </tr>
        </thead>
        <tbody>

            @foreach($payments as $payment)
            <tr style="text-align: center">
                <td>
                    {{$payment->id}}
                </td>
                <td>
                    <!-- Transactions Show with payment ID -->
                    <a href="{{route('payment.show',$payment->id)}}">
                        {{$payment->title}}
                    </a>
                </td>

                <td>{{$payment->status}}</td>
                <td>{{$payment->total_amount}}</td>
                <td>{{$payment->created_at}}</td>
                <td>{{$payment->updated_at}}</td>
                <td>
                    @if ($payment->status != 'paid')
                    <a href="{{route('transactions.create','id='.$payment->id)}}">
                        <i class="fa fa-plus"></i>
                    </a>
                    @else
                    done
                    @endif
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
<!-- /.card-body -->
</div>
<!-- /.card -->
</div>
</div>
<!-- /.row -->

@endsection