@extends ('../welcome')
@section('content')
    <style>
        a#campaign {
            text-decoration-line: line-through !important;
        }

        .button5 {
            border-radius: 50%;
            font-size: 16px;
        }

        .select2.select2-container.select2-container--bootstrap4 {
            width: unset !important;
        }
    </style>
    {{-- Main Card --}}
    <div class="card-outline card-info">
        {{-- Main Header (btns) --}}
        <div class='card-header'>
            <div class="card-title text-info" style="font-weight:bold;font-size:30px">
                {{ $lead->name }}
            </div>
            <div style="float:right">
                <!-- Making Call -->
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('leads-makeCall'))
                    @foreach ($lead->phone_numbers as $key => $phoneNumber)
                        @php
                            $countryCode = App\Models\Country::find($phoneNumber->country_id);
                            $leadPhone = '0' . $phoneNumber->phone;
                        @endphp

                        <!--<a class="btn btn-outline-dark" title="Call Number {{ $key + 1 }}"-->
                        <!--    href="https://rfco.vroot.com/api/appDeal/CallDial?identity={{ auth()->user()->code }}&Calltext={{ $leadPhone }}">-->
                        <!--    <i class="fas fa-phone">&nbsp; {{ $key + 1 }}</i>-->
                        <!--</a>-->
                    @endforeach
                @endif
                <!-- End Making Call -->

                <!-- Lead Update -->
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('leads-edit'))
                    <a class="btn btn-outline-info" title="Edit" href="{{ route('leads.edit', $lead->id) }}">
                        <i class="fa fa-pen"></i>
                    </a>
                @endif

                <!-- Create Client Profile -->
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('leads-clientProfile'))
                    @if ($lead->is_client == 0 || $lead->client_id == null)
                        <a class="btn btn-outline-success" title="Client-Profile"
                            href="{{ route('clients.create', $lead->id) }}">
                            <i class="fa fa-address-card"></i>
                        </a>
                    @else
                        <a class="btn btn-outline-success" title="Client-Profile"
                            href="{{ route('clients.show', $lead->client_id) }}">
                            <i class="fa fa-address-card"></i>
                        </a>
                    @endif
                @endif
                <!-- End Client -->

                {{-- get history of lead --}}
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('leads-actionHistory'))
                    <button type="button" class="btn btn-outline-info" style="float:right" title="History"
                        data-toggle="modal" data-target="#leadHistory">
                        <i class="fas fa-history"></i>
                    </button>
                @endif
                {{-- end history of lead --}}

                <!-- Delete Lead -->
                @if (auth()->user()->type == 'admin' ||
                        auth()->user()->role->hasPermission('leads-delete'))
                    @if (empty($lead->client))
                        <button onClick="clickDeletebutton(this)" title="Archive" class="btn btn-outline-danger"
                            data-id="{{ $lead->id }}" data-toggle="modal" data-target="#exampleModalCenter">
                            <i class="fa fa-trash"></i>
                        </button>&nbsp;&nbsp;
                    @endif
                @endif
                <!-- End Delete Lead -->
            </div>
        </div>
        {{-- Main Body --}}
        <div class="card-body">
            <div class=" row" style="justify-content: space-evenly">
                {{-- General Data --}}
                <div class="col-6 shadow p-3">
                    <table>
                        <tr>
                            <th>Email :</th>
                            <td>{{ $lead->email ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>Job Title :</th>
                            <td>{{ $lead->job_title ?? '-' }} </td>
                        </tr>
                        <tr>
                            <th>Came From :</th>
                            <td>{{ $lead->came_from ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Note :</th>
                            <td>{{ $lead->note ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Purpose :</th>
                            <td>{{ $lead->purpose ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Segment :</th>
                            <td>{{ $lead->segment ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Tag :</th>
                            <td>{{ $lead->tag ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Contact Tool :</th>
                            <td>{{ $lead->contact_tool ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Reply Option :</th>
                            <td>{{ $lead->reply_option ?? '' }}</td>
                        </tr>
                        @if (!empty($lead->campaign))
                            <tr>
                                <th>Campaign :</th>
                                <td>
                                    <a href="{{ route('campaigns.show', $lead->campaign->id) }}">
                                        {{ $lead->campaign->name }}
                                    </a>
                                </td>
                            </tr>

                            @if (!empty($lead->project))
                                <tr>
                                    <th>Project :</th>
                                    <td>
                                        <a href="{{ route('projects.show', $lead->project->id) }}">
                                            {{ $lead->project->name }}
                                        </a>
                                    </td>
                                </tr>
                            @endif
                        @endif
                        <tr>
                            <th>Source :</th>
                            <td>{{ $lead->source?->name ?? '' }}</td>
                        </tr>
                        <tr>
                            <th>Status :</th>
                            <td class="text-{{ $lead->LeadStatus?->color ?? '' }}">{{ $lead->LeadStatus?->name ?? '' }}
                            </td>
                        </tr>
                        <tr>
                            <th>Assigned User :</th>
                            @if (!empty($lead->user_id))
                                <td style="font-weight:bold;color:#dc3545;">
                                    <a href="{{ route('users.show', $lead->user->id) }}">
                                        {{ $lead->user->name }}
                                    </a>
                                </td>
                            @else
                                <td style="font-weight:bold;color:#dc3545;">
                                    No Users Assigned To this lead
                                </td>
                            @endif
                        </tr>
                        @if (!empty($lead->created_by_user))
                            <tr>
                                <th>Created by :</th>
                                <td style="font-weight:bold;color:#dc3545;">
                                    <a href="{{ route('users.show', $lead->created_by_user->id) }}">
                                        {{ $lead->created_by_user->name }}
                                    </a>
                                </td>
                            </tr>
                        @else
                        @endif
                        @if ($lastUser != null)
                            <tr>
                                <th>Deadline :</th>
                                <td title="you have to take action on this lead before this date"
                                    style="font-weight:bold;color:#007bff;">
                                    {{ $lastUser->deadline }}
                                </td>
                            </tr>
                        @endif
                    </table>


                </div>

                <div class="col-4">
                    {{-- Phone Number Card --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('leads-phoneNumbers'))
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('leads-create-PhoneNumber'))
                            <button type="button" class="btn btn-" style="color:#17a2b8" title="add new number"
                                data-toggle="modal" data-target="#storePhones">
                                <i class="fas fa-phone"></i>
                                <i class="fas fa-plus"></i>
                            </button>
                        @endif

                        <div class="card card-info card-outline">
                            <div class="card-body table-responsive p-0">
                                <table class="table table-hover text-nowrap">
                                    <tbody>
                                        @forelse($lead->phone_numbers as $phone)
                                            <tr>
                                                <td>
                                                    <a href="https://wa.me/{{ $phone->country->phonecode }}{{ $phone->phone }}" target="_blank">
                                                        {{ $phone->country->phonecode }} {{ $phone->phone }}
                                                    </a>
                                                </td>
                                                <td>
                                                    @if (auth()->user()->type == 'admin' ||
                                                            auth()->user()->role->hasPermission('leads-edit-phoneNumber'))
                                                        <a class="btn btn-light"
                                                            href="{{ route('phones.edit', $phone->id) }}">
                                                            <i class="fas fa-pen" style="color:#17a2b8"></i>
                                                        </a>
                                                    @endif
                                                    @if (auth()->user()->type == 'admin' ||
                                                            auth()->user()->role->hasPermission('leads-delete-phoneNumber'))
                                                        @if (count($lead->phone_numbers) > 1)
                                                            <button onClick="clickDeletePhone(this)" title="Delete"
                                                                type="button" style="height:38px;" class="btn btn-light"
                                                                data-id="{{ $phone->id }}" data-toggle="modal"
                                                                data-target="#PhoneDelete">
                                                                <i class="fa fa-trash" style="color:#dc3545"></i>
                                                            </button>
                                                        @endif
                                                    @endif
                                                </td>
                                            </tr>
                                        @empty
                                            <p class="p-2">No Phone number Available for this Client</p>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif
                    {{-- Assign User Card --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('leads-assignUsers'))
                        <div class="card card-info card-outline">
                            <div class="card-body">
                                <form action="{{ route('leads.reAssignUser', $lead->id) }}" method="post" id="AssignForm">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-8">
                                            <select name="user_id" class="select2 custom-select form-control-border"
                                                id="user_id">
                                                <option value=""></option>
                                                @php $lastUser= $lead->user; @endphp
                                                @if (auth()->user()->type == 'admin')
                                                    @forelse ($UserChildren as $user)
                                                        @if ($lastUser != null)
                                                            <option {{ $lastUser->id == $user->id ? 'selected' : '' }}
                                                                value="{{ $user->id }}">
                                                                {{ $user->name }}
                                                            </option>
                                                        @else
                                                            <option value="{{ $user->id }}">
                                                                {{ $user->name }}
                                                            </option>
                                                        @endif
                                                    @empty
                                                    @endforelse
                                                    
                                                @elseif(auth()->user()->hasRole('Marketing Team Leader') ||
                                                        auth()->user()->hasRole('Sales Admin'))
                                                    @foreach ($users as $user)
                                                        <option value="{{ $user->id }}"
                                                            {{ $user->id == $lead->user_id ? 'selected' : '' }}>
                                                            {{ $user->name }}</option>
                                                    @endforeach
                                                @else
                                                    @for ($i = 0; $i < count($UserChildren); $i++)
                                                        <option value="{{ $UserChildren[$i]['id'] }}"
                                                            {{ $lastUser->id == $UserChildren[$i]['id'] ? 'selected' : '' }}>
                                                            {{ $UserChildren[$i]['name'] }}</option>
                                                    @endfor
                                                    @if(auth()->user()->role->name == "Customer Service Manager")
                                                   
                                                    @foreach($cs_role->users as $user)
                                                    <option value="{{$user->id}}" {{ $user->id == $lead->user_id ? 'selected' : '' }}>
                                                            {{ $user->name }}
                                                    </option>
                                                    @endforeach
                                                @endif
                                                @endif
                                                
                                            </select>
                                        </div>
                                        <div class="form-group col-3">
                                            <button type="submit" title="User with deadline" class="btn btn-outline-info">
                                                <i class="fas fa-user" aria-hidden="true"></i>
                                                <i class="fas fa-clock" aria-hidden="true"></i>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    @endif
                    {{-- Comments and Stream --}}
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('leads-comments'))
                        <div class="card card-info card-outline collapsed-card">
                            <div class="card-header" data-card-widget="collapse">
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('leads-create-comment'))
                                    <button type="button" class="btn btn-" style="color:#17a2b8; float:right"
                                        title="add new Comment" data-toggle="modal" data-target="#createComment">
                                        <i class="fas fa-plus"></i>
                                    </button>
                                @endif
                                <h6 class="card-title">
                                    Comments
                                </h6>
                            </div>
                            <div class="card-body">
                                <table>
                                    <tbody>
                                        @foreach ($lead->streams as $stream)
                                            <form action="{{ route('streams.update', $stream->id) }}" method="post">
                                                @csrf
                                                @method('PUT')
                                                <tr>
                                                    <th>Comment: </th>
                                                    <td>
                                                        <textarea name="comment" class="form-control">{{ $stream->comment ?? '' }}</textarea>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <th>Created by: </th>
                                                    <td>{{ $stream->creator->name ?? '' }}</td>
                                                </tr>
                                                <tr>
                                                    <th>Created at: </th>
                                                    <td>{{ $stream->created_at ?? '' }}</td>
                                                </tr>
                                                @if ($stream->created_at != $stream->updated_at)
                                                    <tr>
                                                        <th>Updated at: </th>
                                                        <td>{{ $stream->updated_at ?? '' }}</td>
                                                    </tr>
                                                @endif
                                                <tr>
                                                    <th>Actions</th>
                                                    <td>
                                                        @if (auth()->user()->type == 'admin' ||
                                                                auth()->user()->role->hasPermission('leads-edit-comment'))
                                                            <button type="submit" class="btn btn-light">
                                                                <i class="fas fa-pen" style="color:#17a2b8"></i>
                                                            </button>
                                                        @endif
                                                        @if (auth()->user()->type == 'admin' ||
                                                                auth()->user()->role->hasPermission('leads-delete-comment'))
                                                            <button onClick="clickDeletestream(this)" title="Delete"
                                                                type="button" style="height:38px;" class="btn btn-light"
                                                                data-id="{{ $stream->id }}" data-toggle="modal"
                                                                data-target="#CommentDelete">
                                                                <i class="fa fa-trash" style="color:#dc3545"></i>
                                                            </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </form>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    @endif
                </div>
                {{-- Communications Card --}}
                <div class="col-12 m-3">
                    <div class="card card-default card-info card-outline">
                        <form action="{{ route('communications.store') }}" method="POST">
                            <div class="card-header">
                                Call Action
                                <!-- Lead History -->
                                @if (auth()->user()->type == 'admin' ||
                                        auth()->user()->role->hasPermission('leads-actionHistory'))
                                    <button type="button" class="btn btn-outline-info" style="float:right"
                                        title="History" data-toggle="modal" data-target="#myModal">
                                        <i class="fas fa-history"></i>
                                    </button>
                                @endif
                                <!-- End Lead History -->
                            </div>
                                <div class="card-body">
                                    @csrf
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <input type="hidden" name="lead_id" value="{{ $lead->id }}">
                                                <input type="hidden" name="state" value="planned">
                                                <div class="row">
                                                    <label class="col-4">Action Method: </label>
                                                    <div class="col-6">
                                                        <select name="action_method"
                                                            class="select2 custom-select form-control-border col-6"
                                                            id="action_methods">
                                                            <option value="Phone">Phone</option>
                                                            <option value="WhatsApp">WhatsApp</option>
                                                            <option value="Email">Email</option>
                                                            <option value="Visit">Visit</option>
                                                            <option value="Facebook">Facebook</option>
                                                            <option value="Walk-In">Walk-In</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="row">
                                                    <input class="action" id="interested" type="radio" name="action"
                                                        value="interested">
                                                    <label for="interested" class="col-3">Interested</label>

                                                    <input id="not-interested" class="action" type="radio"
                                                        name="action" value="not-interested">
                                                    <label for="not-interested" class="col-3">Not Interested</label>

                                                    <input id="no-answer" class="action" type="radio" name="action"
                                                        value="no-answer">
                                                    <label for="no-answer" class="col-3">No Answer</label>
                                                </div>
                                                <div class="row">
                                                    <label class="col-4">Call Action Type: </label>
                                                    <div class="col-6">
                                                        <select name="call_action_id"
                                                            class="select2 custom-select form-control-border col-6"
                                                            id="actionTypes" required>
                                                        </select>
                                                    </div>
                                                </div>
                                                <br>
                                                <div class="row">
                                                    <label for="meeting-time" class="col-4">Next Action time:</label>
                                                    <input type="datetime-local" class="form-control col-6"
                                                        id="meeting-time" name="start_date">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group mb-3">
                                                <textarea type="text" class="form-control" rows="8" cols="30" placeholder="Type Action Details..."
                                                    name="description"></textarea>
                                            </div>

                                        </div>
                                    </div>
                                </div>
                                <div class="card-footer">
                                    <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>


    {{-- Communications history Modal  --}}
    <div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Lead actions History </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                </div>
                <div class="modal-body">
                    @php
                    if(auth()->user()->role->name == 'Sales Agent'){
                        $communications = App\Models\Communication::where(['lead_id'=> $lead->id, 'user_id' => auth()->user()->id])
                            ->orderBy('created_at', 'Desc')
                            ->get();
                    }else{
                        $communications = App\Models\Communication::where('lead_id', $lead->id)
                            ->orderBy('created_at', 'Desc')
                            ->get();
                    }
                    
                    @endphp
                    @foreach ($communications as $communication)
                        @php
                            $date = strtotime($communication->event?->start);
                            $start = \Carbon\Carbon::createFromTimestamp($date);
                        @endphp
                        <div class="row">
                            <table class="col-10">
                                <tbody>
                                    <tr>
                                        <td>
                                            User Name:
                                        </td>
                                        <td>
                                            @if (auth()->user()->type == 'admin' ||
                                                    auth()->user()->role->hasPermission('users-show'))
                                                <a href="{{ route('users.show', $communication->user->id) }}">
                                                    {{ $communication->user->name }}
                                                </a>
                                            @else
                                                <a>
                                                    {{ $communication->user->name }}
                                                </a>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Action Method:
                                        </td>
                                        <td>{{ $communication->action_method }}</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Call Action:
                                        </td>
                                        <td>{{ $communication->callAction->name }}</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Description:
                                        </td>
                                        <td>{{ $communication->description }}</td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Status:
                                        </td>
                                        <td>
                                            {{ $communication->CommunicationStatus?->name }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Created at:
                                        </td>
                                        <td>
                                            {{ $communication->created_at }}
                                        </td>
                                    </tr>
                                    @if (!empty($communication->event))
                                        <tr>
                                            <td>
                                                Title:
                                            </td>
                                            <td>
                                                <span
                                                    style="font-weight:bold;color:#17a2b8;">{{ $communication->event?->title }}</span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td>
                                                Date of Next Action :
                                            </td>
                                            <td>

                                                <span style="font-weight:bold">{{ $start }}</span>
                                            </td>
                                        </tr>
                                    @endif
                                </tbody>
                            </table>
                            <form action="{{ route('communications.changeStatus', $communication->id) }}" method="POST">
                                @csrf
                                
                                @if ($communication->state == 'planned' && $current_date->toDateString() <= $start->toDateString())
                                    <input type="hidden" name="state" value="done">
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-info">
                                            <i class="fas fa-check"></i>
                                        </button>
                                    </div>
                                @endif
                            </form>
                        </div>
                        <hr>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    {{-- Lead History Modal --}}
    <div class="modal fade" id="leadHistory" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Lead History </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                </div>
                <div class="modal-body">
                    <table
                        id={{ auth()->user()->type == 'admin' ||auth()->user()->role->hasPermission('lead-logs-export')? 'example1': 'nonExport' }}
                        class="table table-bordered ">
                        <thead>
                            <tr>
                                {{-- <th>Log</th> --}}
                                <th>Event</th>
                                <th>Causer</th>
                                <th>Description</th>
                                <th>Created at</th>
                            </tr>
                        </thead>
                        <tbody>

                            @for ($i = 0; $i < count($logs); $i++)
                                @php
                                    if ($logs[$i]->event == 'updated') {
                                        $log = json_decode($logs[$i]->properties);
                                        $oldLog = get_object_vars($log->old);
                                        $newLog = get_object_vars($log->attributes);
                                    }
                                @endphp
                                <tr data-toggle="modal"
                                    data-target={{ $logs[$i]->event == 'updated' ? '#logDetails' . $i : '' }}
                                    class="modalData">
                                    <td> {{ $logs[$i]->event }} </td>
                                    <td>
                                        @if (!empty($logs[$i]->causer_type))
                                            {{ $logs[$i]->causer_type::find($logs[$i]->causer_id)->name ?? ''}}
                                        @else
                                            withdrow
                                        @endif
                                    </td>
                                    <td> {{ $logs[$i]->description }} </td>
                                    <td>{{ $logs[$i]->created_at }}</td>
                                </tr>
                                <div class="modal fade" id={{ 'logDetails' . $i }} role="dialog" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered" role="document">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">Log Details</h5>
                                                <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                                            </div>
                                            @if ($logs[$i]->event == 'updated')
                                                
                                                <div class="modal-body">
                                                    <div class="row" style="justify-content: space-between">
                                                        <div class="col-4">
                                                            <h5>Old</h5>
                                                            @foreach ($oldLog as $key => $value)
                                                                {{-- {{$key}} --}}
                                                                @if ($key == 'updated_at')
                                                                    @continue
                                                                @endif
                                                                @switch($key)
                                                                    @case('user_id')
                                                                        <li>Sales Man:
                                                                            @php
                                                                                $sales = App\Models\User::find($value);
                                                                            @endphp
                                                                            {{ $sales->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('campaign_id')
                                                                        <li>Campaign:
                                                                            @php
                                                                                $campaign = App\Models\Campaign::find($value);
                                                                            @endphp
                                                                            {{ $campaign->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('source_id')
                                                                        <li>Source:
                                                                            @php
                                                                                $source = App\Models\Source::find($value);
                                                                            @endphp
                                                                            {{ $source->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('status_id')
                                                                        <li>Status:
                                                                            @php
                                                                                $status = App\Models\Status::find($value);
                                                                            @endphp
                                                                            {{ $status->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @default
                                                                        <li>{{ $key }} :
                                                                            {{ $value }}
                                                                        </li>
                                                                @endswitch
                                                            @endforeach
                                                        </div>
                                                        <div class="col-4">
                                                            <h5>New</h5>
                                                            @foreach ($newLog as $key => $value)
                                                                @if ($key == 'updated_at')
                                                                    @continue
                                                                @endif
                                                                @switch($key)
                                                                    @case('user_id')
                                                                        <li>Sales Man:
                                                                            @php
                                                                                $sales = App\Models\User::find($value);
                                                                            @endphp
                                                                            {{ $sales->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('campaign_id')
                                                                        <li>Campaign:
                                                                            @php
                                                                                $campaign = App\Models\Campaign::find($value);
                                                                            @endphp
                                                                            {{ $campaign->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('source_id')
                                                                        <li>Source:
                                                                            @php
                                                                                $source = App\Models\Source::find($value);
                                                                            @endphp
                                                                            {{ $source->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @case('status_id')
                                                                        <li>Status:
                                                                            @php
                                                                                $status = App\Models\Status::find($value);
                                                                            @endphp
                                                                            {{ $status->name ?? '' }}
                                                                        </li>
                                                                    @break

                                                                    @default
                                                                        <li>{{ $key }} :
                                                                            {{ $value }}
                                                                        </li>
                                                                @endswitch
                                                            @endforeach
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            @endfor
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    {{-- Delete Modal   --}}
    <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenter"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Archive Record</h5>
                    <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                </div>
                <div class="modal-body">
                    <p>Are you sure to archive this lead ?</p>
                </div>
                <div class="modal-footer">
                    <form action="{{ route('leads.reAssignUser', $lead->id) }}" method="post" id="AssignForm">
                        @csrf
                        @method('DELETE')
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">Yes</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    {{-- Delete Phone Number Modal  --}}
    <div class="modal fade" id="PhoneDelete" tabindex="-1" role="dialog" aria-labelledby="PhoneDelete"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Number
                        <!-- <button class="btn-close" type="button" data-dismiss="modal" aria-label="Close"></button> -->
                </div>
                <div class="modal-body">
                    <p>Are you sure to Delete this Number ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    {{-- Store Phone Number  --}}
    <div class="modal fade" id="storePhones" role="dialog" aria-labelledby="storePhonesLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="storePhonesLabel">add new number
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                </div>
                <form action="{{ route('phones.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input class="form-control" name="lead_id" type="hidden" value="{{ $lead->id }}">
                        </div>
                        <div class="row">

                            <div class="form-group col-4">
                                <select class="form-control" name="country_id" required>
                                    <option></option>
                                    @foreach ($codes as $code)
                                        <option value="{{ $code->id }}">{{ $code->name }} +{{ $code->phonecode }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group col-8">
                                <input class="form-control" name="phone" type="text" required>
                                <div id="phone-error" style="display:none;"></div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
  
            </div>
        </div>
    </div>

    {{-- Store Comment  --}}
    <div class="modal fade" id="createComment" tabindex="-1" role="dialog" aria-labelledby="createCommentLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="createCommentLabel">New Comment
                </div>
                <form action="{{ route('streams.store') }}" method="post">
                    @csrf
                    <div class="modal-body">
                        <div class="form-group">
                            <input name="lead_id" type="hidden" value="{{ $lead->id }}">
                        </div>

                        <div class="form-group">
                            <textarea name="comment" class="form-control"></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info">submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Delete comment Modal  --}}
    <div class="modal fade" id="CommentDelete" tabindex="-1" role="dialog" aria-labelledby="CommentDelete"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Number
                </div>
                <div class="modal-body">
                    <p>Are you sure to Delete this Comment ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-info yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div>

    <!-- Ensure jQuery is loaded only once and before any script that uses it -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        jQuery(document).ready(function($) {
            // Remove leading zeros from phone number input
            $(document).on('input', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            
            $(document).on('blur', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                if (phoneNumber.length > 1 && phoneNumber.startsWith('0')) {
                    $(this).val(phoneNumber.replace(/^0+/, ''));
                }
            });
            
            // Phone duplication check for lead phone
            $(document).on('input', 'input[name="phone"]', function() {
                var phoneNumber = $(this).val();
                var countrySelect = $(this).closest('.row').find('select[name="country_id"]');
                var selectedCountryCode = countrySelect.find('option:selected').text().split('+').pop().trim();
                var errorDiv = $(this).siblings('#phone-error');
                
                if (phoneNumber.length > 3) {
                    $.ajax({
                        url: "{{ route('check-mobile-number') }}",
                        type: 'POST',
                        data: {
                            mobile_number: phoneNumber,
                            country_code: selectedCountryCode,
                            _token: '{{ csrf_token() }}'
                        },
                        success: function(response) {
                            if (response.exists) {
                                errorDiv.text('This Phone Number is Duplicated').show()
                                    .removeClass('valid-feedback').addClass('invalid-feedback');
                            } else {
                                errorDiv.text('Phone Number is available').show()
                                    .removeClass('invalid-feedback').addClass('valid-feedback');
                            }
                        },
                        error: function() {
                            errorDiv.text('Error occurred while checking the phone number')
                                .show().removeClass('valid-feedback').addClass('invalid-feedback');
                        }
                    });
                } else {
                    errorDiv.hide();
                }
            });
        });
    </script>
    
@endsection