@extends ('../welcome')
@section('content')
    <style>
        .clickable-row:hover {
            background-color: #17a2b8;
            opacity: 0.8;
            cursor: pointer;
        }

        a:hover {
            cursor: pointer;

        }

        th {
            width: 15%;
        }

        .modal.show .modal-dialog {
            -webkit-transform: none;
            transform: none;
            max-width: 75%;
        }

        th {
            max-width: 20%;
        }

        input.largerBox {
            width: 22px;
            height: 21px;
        }
    </style>

    <div class="card">
        <div class="card-header">
            <h5 class="card-title">{{ $inquiry->title }}</h5>
        </div>
        <div class="card-body">
            <table>
                <tbody>
                    <tr>
                        <th>Type: </th>
                        <td>{{ $inquiry->inqType?->name ?? '' }}</td>
                    </tr>
                    <tr>
                        <th>Number: </th>
                        <td>{{ $inquiry->number }}</td>
                    </tr>
                    <tr>
                        <th>Location: </th>
                        <td>{{ $inquiry->location }}</td>
                    </tr>
                    <tr>
                        <th>Broker: </th>

                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('brokers-show'))
                            <td>
                                <a href="{{ route('brokers.show', $inquiry->broker_id) }}">
                                    {{ $inquiry->broker?->name ?? '' }}
                                </a>
                            </td>
                        @else
                            <td>
                                {{ $inquiry->broker?->name ?? '' }}
                            </td>
                        @endif
                    </tr>
                    @if ($inquiry->lead_id != null)
                        <tr>
                            <th>Lead: </th>
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('leads-show'))
                                <td>
                                    <a href="{{ route('leads.show', $inquiry->lead_id) }}">
                                        {{ $inquiry->lead?->name ?? '' }}
                                    </a>
                                </td>
                            @else
                                <td>
                                    {{ $inquiry->lead?->name ?? '' }}
                                </td>
                            @endif
                        </tr>
                    @endif
                    <tr>
                        <th>Campaign: </th>
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('campaigns-show'))
                            <td>
                                <a href="{{ route('campaigns.show', $inquiry->campaign_id) }}">
                                    {{ $inquiry->campaign?->name ?? '' }}
                                </a>
                            </td>
                        @else
                            <td>
                                {{ $inquiry->campaign?->name ?? '' }}
                            </td>
                        @endif
                    </tr>
                    <tr>
                        <th>Source: </th>
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('sources-show'))
                            <td>
                                <a href="{{ route('sources.show', $inquiry->source_id) }}">
                                    {{ $inquiry->source?->name ?? '' }}
                                </a>
                            </td>
                        @else
                            <td>
                                {{ $inquiry->source?->name ?? '' }}
                            </td>
                        @endif
                    </tr>
                    <tr>
                        <th>Assigned To: </th>
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('users-show'))
                            <td>
                                <a href="{{ route('users.show', $inquiry->user_id) }}">
                                    {{ $inquiry->user?->name ?? '' }}
                                </a>
                            </td>
                        @else
                            <td>
                                {{ $inquiry->user?->name ?? '' }}
                            </td>
                        @endif
                    <tr>
                        <th>Description: </th>
                        <td>{{ $inquiry->description ?? '' }}</td>
                    </tr>
                </tbody>
            </table>
        </div>
        <div class="card-footer">
            @if (empty($inquiry->lead))
                <tr>
                    <td>
                        @if (auth()->user()->type == 'admin' ||
                                auth()->user()->role->hasPermission('brokers-edit-requests'))
                            <button type="button" class="btn btn-info" title="edit Inquiry" data-toggle="modal"
                                data-target="#editInquiry">
                                Edit
                            </button>
                        @endif
                    </td>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('brokers-reAssign-requests'))
                        <button type="button" class="btn btn-warning" title="Re-assign User" data-toggle="modal"
                            data-target="#reAssignUser">
                            Re-assign user
                        </button>
                    @endif
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('brokers-convert-requests'))
                        <button type="button" class="btn btn-default" title=" Convert To lead" data-toggle="modal"
                            data-target="#convertRequest">
                            Convert To lead
                        </button>
                    @endif
                </tr>
            @endif
        </div>
    </div>

    {{-- <div class="modal fade" id="AgentModal" tabindex="-1" role="dialog" aria-labelledby="AgentModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    <p>Are you sure to delete this record ?</p>
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                </form>
            </div>
        </div>
    </div> --}}

    {{-- Edit Inquiry --}}
    <div class="modal fade" id="editInquiry" role="dialog" aria-labelledby="editInquiry" aria-hidden="true">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Edit Request </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('inquiries.update', $inquiry->id) }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        @method('PUT')
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <label for="title">title: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="text" value="{{ $inquiry->title }}" name="title"
                                            class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="number">number: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="number" name="number" value="{{ $inquiry->number }}"
                                            class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="location">location: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="text" name="location" value="{{ $inquiry->location }}"
                                            class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description">{{ $inquiry->description }}</textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="broker">broker: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="hidden" name="broker_id" value="{{ $inquiry->broker_id }}">
                                        <input type="text" value="{{ $inquiry->broker->name }}" class="form-control"
                                            disabled>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="agents">Agents: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="agent_id" class="select2 custom-select form-control-border"
                                            id="agents">
                                            @foreach ($agents as $agent)
                                                <option value="{{ $agent->id }}"
                                                    {{ $agent->id == $inquiry->agent_id ? 'selected' : '' }}>
                                                    {{ $agent->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="statuses">Status: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="status_id" class="select2 custom-select form-control-border"
                                            id="status">
                                            <option value=""></option>
                                            @foreach ($statuses as $status)
                                                <option value="{{ $status->id }}"
                                                    {{ $status->id == $inquiry->status_id ? 'selected' : '' }}>
                                                    {{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="sources">Sources: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="source_id" class="select2 custom-select form-control-border"
                                            id="source">
                                            <option value=""></option>
                                            @foreach ($sources as $source)
                                                <option value="{{ $source->id }}"
                                                    {{ $source->id == $inquiry->source_id ? 'selected' : '' }}>
                                                    {{ $source->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="inqType">Request Type: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="inq_type_id" class="select2 custom-select form-control-border"
                                            id="inqTypes ">
                                            <option value=""></option>
                                            @foreach ($inqTypes as $type)
                                                <option value="{{ $type->id }}"
                                                    {{ $type->id == $inquiry->inq_type_id ? 'selected' : '' }}>
                                                    {{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="user">Assigne To: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="user_id" class="select2 custom-select form-control-border"
                                            id="users ">
                                            <option value=""></option>
                                            @foreach ($users as $user)
                                                <option value="{{ $user->id }}"
                                                    {{ $user->id == $inquiry->user_id ? 'selected' : '' }}>
                                                    {{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Re-Assign User --}}
    <div class="modal fade" id="reAssignUser" role="dialog" aria-labelledby="reAssignUser" aria-hidden="true">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Re-Assign User</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form action="{{ route('inquiryReAssign') }}" method="POST">

                    <div class="modal-body">
                        @csrf
                        {{-- @method('PUT') --}}
                        <input type="hidden" value="{{ $inquiry->id }}" name="inquiry_id">
                        <select name="user_id" class="select2 custom-select form-control-border" id="type">
                            @foreach ($users as $user)
                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    {{-- Convert To CIL --}}
    <div class="modal fade" id="convertRequest" role="dialog" aria-labelledby="convertRequest" aria-hidden="true">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Re-Assign User</h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form id="myForm" action="{{ route('leads.store') }}" method="POST">
                    <div class="card">
                        <div class="card-body register-card-body mt-5 ml-4">

                            @csrf
                            <div class="row">
                                <div class="col-6">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="form-group col-10">
                                                    <label>Name</label>
                                                    <input type="hidden" name="inquiry_id" value="{{ $inquiry->id }}">
                                                    <input type="text" name="name" value="{{ old('name') }}"
                                                        class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-10">
                                                    <label>Came From</label>
                                                    <input type="text" name="came_from"
                                                        value="{{ old('came_from') }}" class="form-control">
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="form-group col-5">
                                                    <label>Job Title</label>
                                                    <input type="text" class="form-control"
                                                        value="{{ old('job_title') }}" name="job_title">
                                                </div>
                                                <div class="form-group col-5">
                                                    <label>Email</label>
                                                    <input type="email" class="form-control"
                                                        placeholder="email@example.com" value="{{ old('email') }}"
                                                        name="email">
                                                </div>
                                            </div>

                                            <div class="row">

                                                <div class="form-group col-5">
                                                    <label>Contact Tools</label>
                                                    <select name="contact_tool"
                                                        class="select2 custom-select form-control-border">
                                                        <option value="phone">phone</option>
                                                        <option value="email">email</option>
                                                        <option value="whatsApp">whatsApp</option>
                                                        <option value="visit">visit</option>
                                                        <option value="facebook">facebook</option>
                                                        <option value="walk-in">walk-in</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-5">
                                                    <label>Reply Options</label>
                                                    <select name="reply_option"
                                                        class="select2 custom-select form-control-border">
                                                        <option value="replied">replied</option>
                                                        <option value="switched-off">switched off</option>
                                                        <option value="no-answer">no answer</option>
                                                        <option value="wrong-number">wrong number</option>
                                                        <option value="thanks-for-calling">thanks for calling</option>
                                                        <option value="thanks-for-meeting">thanks for meeting</option>
                                                        <option value="Set-a-meeting">Set a Meeting</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-4">
                                                    <label>Purpose</label>
                                                    <select name="purpose"
                                                        class="select2 custom-select form-control-border">
                                                        <option value="investment">investment</option>
                                                        <option value="housing">housing</option>
                                                        <option value="for-children">for-children</option>
                                                        <option value="vacation">vacation</option>
                                                        <option value="2nd-home">2nd-home</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-2">
                                                    <label>Segments</label>
                                                    <select name="segment"
                                                        class="select2 custom-select form-control-border">
                                                        <option value="A+">A+</option>
                                                        <option value="A">A</option>
                                                        <option value="B+">B+</option>
                                                        <option value="B">B</option>
                                                        <option value="C+">C+</option>
                                                        <option value="C">C</option>
                                                    </select>
                                                </div>

                                                <div class="form-group col-4">
                                                    <label>Tags</label>
                                                    <select name="tag"
                                                        class="select2 custom-select form-control-border">
                                                        <option value="VIP">VIP</option>
                                                        <option value="urgent">urgent</option>
                                                        <option value="potential-client">potential-client</option>
                                                        <option value="none">none</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="status_id" value="1">
                                </div>
                                <div class="col-6">
                                    <div class="card card-outline card-info">
                                        <div class="card-header">
                                            <strong>Cil</strong>
                                        </div>
                                        <div class="card-body">
                                            <table>
                                                <tbody>
                                                    <tr>
                                                        <th></th>
                                                        <td>
                                                            <input type="hidden" name="type" value="cil">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Broker: </th>
                                                        <td>
                                                            <input type="hidden" name="broker_id"
                                                                value="{{ $inquiry->broker_id }}">
                                                            <input type="text" readonly class="form-control"
                                                                value="{{ $inquiry->broker?->name }}">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Agent: </th>
                                                        <td>
                                                            <input type="hidden" name="agent_id"
                                                                value="{{ $inquiry->agent_id }}">
                                                            <input type="text" readonly class="form-control"
                                                                value="{{ $inquiry->agent?->name }}">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Campaign: </th>
                                                        <td>
                                                            <input type="hidden" name="campaign_id"
                                                                value="{{ $inquiry->campaign_id }}">
                                                            <input type="text" readonly class="form-control"
                                                                value="{{ $inquiry->campaign?->name }}">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Source: </th>
                                                        <td>
                                                            <input type="hidden" name="source_id"
                                                                value="{{ $inquiry->source_id }}">
                                                            <input type="text" readonly class="form-control"
                                                                value="{{ $inquiry->source?->name }}">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Civil ID number: </th>
                                                        <td>
                                                            <input id="civil_id" type="number" class="form-control"
                                                                name="civil_id">
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>Note: </th>
                                                        <td>
                                                            <textarea name="note" id="note" class="form-control" placeholder="Note...."></textarea>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th style="width:30px;">Confirmed ? </th>
                                                        <td>
                                                            <input id="confirmed" type="checkbox"
                                                                class="form-check-input largerBox"
                                                                style="margin-left:30px;" name="confirmed">
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                    <div id="inputFormRow">
                                        <div class="card card-outline card-info">
                                            <div class="card-header">
                                                <button id="addRow" type="button" class="btn btn-info"
                                                    style="float:right">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                                <p class="card-title" style="font-weight:bold">Phone Number</p>
                                            </div>
                                            <div class="card-body">
                                                <div class="row">
                                                    <div class="col-4">
                                                        <label>Country</label>
                                                        <select name="country_id[]"
                                                            class="select2 custom-select form-control-border"
                                                            id="countries">
                                                            @foreach ($countries as $country)
                                                                <option value="{{ $country->id }}"
                                                                    {{ $country->name == 'Egypt' ? 'selected' : '' }}>
                                                                    {{ $country->name }}
                                                                    - +{{ $country->phonecode }}
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </div>

                                                    <div class="col-6">
                                                        <label>Mobile Number</label>
                                                        <input type="text" class="form-control m-input"
                                                            value="{{ old('phone_number') }}" placeholder="Phone Number"
                                                            name="mobile_number[]" id="phone" required>
                                                    </div>
                                                </div>
                                                <div id="newRow"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="col-10" style="display:flex;justify-content:center;">
                                <button type="submit" class="btn btn-info">Submit</button>
                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script type="text/javascript">
        // add row
        $("#addRow").click(function() {
            var html = '';
            html += `
    <div id="inputFormRow">
        <div class="row" >
            <div class="col-4">
                <div class="form-group" style="margin-top:20px;">
                <select name="country_id[]" class="custom-select form-control-border" id="countries2">
                    @foreach ($countries as $country)
                    <option value="{{ $country->id }}" {{ $country->name == 'Egypt' ? 'selected' : '' }}>{{ $country->name }} +{{ $country->phonecode }}</option>
                    @endforeach
                </select>
                </div>
            </div>
            <div class="col-6" style="margin-top:20px;">
                <input type="text" class="form-control m-input" 
                    placeholder="Phone Number" id ="phone2" name="mobile_number[]">
            </div>

            <div class="col-2" style="padding-top:35px;margin-top:-15px">
                <button id="removeRow" type="button" class="btn btn-danger">
                <i class="fas fa-trash-alt"></i>
                </button>
            </div>
        </div>
    </div>`;

            $('#newRow').append(html);
        });
        // remove row
        $(document).on('click', '#removeRow', function() {
            $(this).closest('#inputFormRow').remove();
        });
    </script>
    <!-- /.row -->
    {{-- <script>
        clickDelete = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('agents.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#AgentModal').find($('form')).attr('action', route);
        }
    </script> --}}
@endsection
