@extends ('../welcome')
@section('content')
    <style>
        .pagination nav .relative.z-0.inline-flex {
            display: inline-flex;
        }

        .pagination nav .hidden {
            display: unset !important;
        }

        .pagination nav .flex-1.justify-between {
            padding: 15px 0
        }

        .pagination nav .flex.justify-between.flex-1 {
            display: none
        }
        tr{
            margin-top:20px !important;
        }
    </style>
    <!-- Filters -->
    {{-- <form>
        <div class="card card-info card-outline collapsed-card">
            <div class="card-header" class="btn btn-tool" data-card-widget="collapse">
                <div class="card-title" style="font-weight:bold; font-size:20px">
                    Filter
                </div>
            </div>
            <div class="card-body">
                <form>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                <label>Creator</label>
                                <select name="creators_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($creators as $creator)
                                        <option value="{{ $creator->id }}">{{ $creator->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="form-group">
                                <label>brokers</label>
                                <select name="brokers_id[]" class="select2 custom-select form-control-border" multiple>
                                    @foreach ($brokers as $broker)
                                        <option value="{{ $broker->id }}">{{ $broker->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="col-6">
                            <div class="row">
                                <div class="form-group col-6">
                                    <label>From</label>
                                    <input type="time" value="{{ $_GET['time1'] ?? '' }}" class="form-control"
                                        name="time1">
                                </div>
                                <div class="form-group col-6">
                                    <label>to</label>

                                    <input type="time" name="time2" value="{{ $_GET['time2'] ?? '' }}"
                                        class="form-control">
                                </div>
                            </div>
                            <div class="row">
                                <div class="form-group col-6">
                                    <input type="date" name="date1" value="{{ $_GET['date1'] ?? '' }}"
                                        class="form-control">
                                </div>
                                <div class="form-group col-6">
                                    <input type="date" name="date2" value="{{ $_GET['date2'] ?? '' }}"
                                        class="form-control">
                                </div>
                            </div>

                            <a href="{{ url()->previous() }}" class="btn btn-default">Back</a>
                            <button type="submit" class="btn btn-info" style="float:left">filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </form> --}}
    <!-- End filters -->


    {{-- Index Table --}}
    <!-- /.Table Card-->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title"> Requests </h5>
                    @if (auth()->user()->type == 'admin' ||
                            auth()->user()->role->hasPermission('brokers-create-requests'))
                        <button type="button" class="btn btn-light" style="float:right" title="create Request"
                            data-toggle="modal" data-target="#myModal">
                            <i style="color:black" class="fas fa-plus"></i>
                        </button><br>
                    @endif
                    <div class="card-title">Total: {{ $inquiries->total() }}</div>
                </div>
                <div class="card-body">
                    <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('inquiries-export') ? 'example2' : 'nonExport' }} 
                        class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>title</th>
                                <th>type</th>
                                <th>number</th>
                                <th>location</th>
                                <th>broker</th>
                                <th>agent</th>
                                <th>user</th>
                                <th>source</th>
                                <th>Created date</th>
                                <th>Created Time</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($inquiries as $inquiry)
                                <?php $temp = explode(' ', $inquiry->created_at->setTimezone('Africa/Cairo')); ?>
                                <tr>
                                    <td>{{ $inquiry->id }}</td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('brokers-show-requests'))
                                            <a href="{{ route('inquiries.show', $inquiry->id) }}">
                                                {{ $inquiry->title }}
                                            </a>
                                        @else
                                            {{ $inquiry->title }}
                                        @endif
                                    </td>
                                    <td>
                                        {{ $inquiry->inqType?->name ?? '' }}
                                    </td>
                                    <td>
                                        {{ $inquiry->number }}
                                    </td>
                                    <td>
                                        {{ $inquiry->loaction }}
                                    </td>
                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('brokers-show'))
                                            <a href="{{ route('brokers.show', $inquiry->broker_id) }}">
                                                {{ $inquiry->broker?->name ?? '' }}
                                            </a>
                                        @else
                                            {{ $inquiry->broker?->name ?? '' }}
                                        @endif
                                    </td>

                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('agents-show'))
                                            <a href="{{ route('agents.show',  $inquiry->agent_id) }}">
                                                {{ $inquiry->agent?->name ?? '' }}
                                            </a>
                                        @else
                                            {{ $inquiry->agent?->name ?? '' }}
                                        @endif
                                    </td>

                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('users-show'))
                                            <a href="{{ route('users.show', $inquiry->user_id) }}">
                                                {{ $inquiry->user?->name ?? '' }}
                                            </a>
                                        @else
                                            {{ $inquiry->user?->name ?? '' }}
                                        @endif
                                    </td>

                                    <td>
                                        @if (auth()->user()->type == 'admin' ||
                                                auth()->user()->role->hasPermission('sources-show'))
                                            <a href="{{ route('sources.show', $inquiry->source_id) }}">
                                                {{ $inquiry->source?->name ?? '' }}
                                            </a>
                                        @else
                                            {{ $inquiry->source?->name ?? '' }}
                                        @endif
                                    </td>

                                    <td>{{ $temp[0] }}</td>
                                    <td>{{ $temp[1] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <div class="pagination">
                        {{ $inquiries->appends(request()->input())->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- End Index Table --}}


    {{-- Create Activity --}}
    <div class="modal fade" id="myModal" role="dialog">
        <div class="modal-dialog">

            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title">Create Activity </h4>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>

                </div>
                <form action="{{ route('inquiries.store') }}" method="POST">
                    <div class="modal-body">
                        @csrf
                        <table>
                            <tbody>
                                <tr>
                                    <td>
                                        <label for="title">title: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="text" name="title" class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="number">number: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="number" name="number" class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="location">location: </label>
                                    </td>
                                    <td class="form-group">
                                        <input type="text" name="location" class="form-control" required>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="description">Description: </label>
                                    </td>
                                    <td class="form-group">
                                        <textarea type="text" class="form-control" rows="8" cols="30" name="description" id="description"></textarea>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="broker">broker: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="broker_id" class="custom-select form-control-border" id="broker">
                                            <option value=""></option>
                                            @foreach ($brokers as $broker)
                                                <option value="{{ $broker->id }}">{{ $broker->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="agents">Agents: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="agent_id" class="select2 custom-select form-control-border"
                                            id="agents">
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="statuses">Status: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="status_id" class="select2 custom-select form-control-border" id="status">
                                            <option value=""></option>
                                            @foreach ($statuses as $status)
                                                <option value="{{ $status->id }}">{{ $status->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                                <tr>
                                    <td>
                                        <label for="sources">Sources: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="source_id" class="select2 custom-select form-control-border" id="source">
                                            <option value=""></option>
                                            @foreach ($sources as $source)
                                                <option value="{{ $source->id }}">{{ $source->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="inqType">Request Type: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="inq_type_id" class="select2 custom-select form-control-border" id="inqTypes ">
                                            <option value=""></option>
                                            @foreach ($inqTypes as $type )
                                                <option value="{{ $type->id }}">{{ $type->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <label for="user">Assigne To: </label>
                                    </td>
                                    <td class="form-group">
                                        <select name="user_id" class="select2 custom-select form-control-border" id="users ">
                                            <option value=""></option>
                                            @foreach ($users as $user )
                                                <option value="{{ $user->id }}">{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info" style="margin-left:45%">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    {{-- End Create Activity --}}



    <script src="{{ asset('asset/plugins/jquery/jquery.min.js') }}"></script>
    <script src="//ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <script>
        $(document).on('change', '#broker', function() {
            console.log(this.value);
            var data = this.value;

            $.ajax({
                data: {
                    'broker_id': data
                },
                method: "POST",
                url: "{{ route('brokerAgents') }}",

                success: function(dataResult) {
                    var dataResult = JSON.parse(dataResult);
                    console.log(dataResult.agents);
                    let agents = "";


                    Array.from(dataResult.agents).forEach(myFunction2);

                    function myFunction2(item, index) {
                        agents += `<option value="` + item.id + `">` + item.name + `</option>`;
                    }
                    document.getElementById("agents").innerHTML = agents;
                }
            });
        });
    </script>
@endsection
