@extends ('../welcome')


@section('content')

<head>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.0/css/bootstrap.min.css">
</head>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Create Contract</h3>
        <!-- Button trigger modal -->
        @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('contracts-codes'))
            <button type="button" style="float:right" class="btn btn-outline-dark" data-toggle="modal" data-target="#exampleModalLong">
                <i class="far fa-file-code"></i>
            </button>
        @endif
    
    </div>
    <!-- /.card-header -->
    <div class="card-body">

        <form action="{{ route('contracts.store') }}" method="POST">
            @csrf

            <!-- text input -->
            <div class="form-group">
                <label>Name</label>
                <input type="text" name="name" class="form-control" placeholder="Contract Name">
            </div>

            <input type="hidden" name="type" value="contract">
            <!-- textarea -->
            <div class="form-group">
                <textarea class="form-control" name="body"></textarea>
            </div>


            <button type="submit" class="btn btn-primary col start">
                <span>Submit</span>
            </button>

        </form>
    </div>
    <!-- /.card-body -->
</div>


<!-- Modal -->
<div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
    <div class="modal-dialog" role="document">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="exampleModalLongTitle">Codes</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body">
          <table id="codes" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>Code</th>
                    <th>Purpose</th>
                </tr>
            </thead>
            <tbody>
                @foreach($codes as $code)
                <tr>
                    <td>{{$code->code}}</td>
                    <td>{{$code->purpose}}</td>
                </tr>
                @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>

<script src="{{asset('asset/plugins/jquery/jquery.min.js')}}"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>

<script src="https://cdn.tiny.cloud/1/no-api-key/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>


<script>
tinymce.init({
    selector: 'textarea'
});

$(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            // initialize calendar in all events
            
            $('#codes thead tr')
                .clone(true)
                .addClass('filters')
                .appendTo('#codes thead');

            var table = $('#codes').DataTable({
                "responsive": true,
                "lengthChange": true,
                "autoWidth": true,
                
                orderCellsTop: true,
                fixedHeader: false,
                "scrollX": true,
                "scrolly": true,
                "paging": false,
                initComplete: function() {
                    var api = this.api();

                    // For each column
                    api
                        .columns()
                        .eq(0)
                        .each(function(colIdx) {
                            // Set the header cell to contain the input element
                            var cell = $('.filters th').eq(
                                $(api.column(colIdx).header()).index()
                            );
                            var title = $(cell).text();
                            $(cell).html('<input type="text" placeholder="' + title + '" />');

                            // On every keypress in this input
                            $('input',
                                    $('.filters th').eq($(api.column(colIdx).header()).index())
                                )
                                .off('keyup change')
                                .on('change', function(e) {
                                    // Get the search value
                                    $(this).attr('title', $(this).val());
                                    var regexr =
                                        '({search})'; //$(this).parents('th').find('select').val();

                                    var cursorPosition = this.selectionStart;
                                    // Search the column for that value
                                    api
                                        .column(colIdx)
                                        .search(
                                            this.value != '' ?
                                            regexr.replace('{search}', '(((' + this.value +
                                                ')))') :
                                            '',
                                            this.value != '',
                                            this.value == ''
                                        )
                                        .draw();
                                })
                                .on('keyup', function(e) {
                                    e.stopPropagation();

                                    $(this).trigger('change');
                                    $(this).focus()[0].setSelectionRange(cursorPosition,
                                        cursorPosition);
                                });
                        });
                },
            }).buttons().container().appendTo('#codes_wrapper .col-md-6:eq(0)');


        });
</script>
@endsection