@extends ('../welcome')

@section ('content')

<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Client Contracts</h2>&nbsp;&nbsp;
            <a href="{{route('cContractsArchive')}}" class="btn btn-outline-success" title="Archive" style="float:right"><i class="fas fa-archive"></i></a>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <div class="card-title">Total: {{count($contracts)}}</div>
        </div>
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('client-contracts-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Contract Name</th>
                        <th>Client</th>
                        <th>Unit</th>
                        <th>Contract Date</th>
                        <th>is Delivered ? </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($contracts as $contract)
                    <tr class='clickable-row' data-href="{{route('printContract',$contract->id) }}">
                        <td>{{$contract->contract->name}}</td>
                        <td>{{$contract->client->name}}</td>
                        <td>{{$contract->unit->name}}</td>
                        <td>{{$contract->contract_date}}</td>
                        <td>{{$contract->is_delivered == '0' ? 'Not Yet' : 'delivered'}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
clickDeletebutton = (e) => {
    const modelId = e.getAttribute("data-id");
    var route = "{{route('contracts.destroy',':id')}}";
    route = route.replace(':id', modelId);
    $('#exampleModalCenter').find($('form')).attr('action', route);
}
</script>
@endsection