@extends ('../welcome')

@section ('content')

<div class="col-12">
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Contract Codes</h2>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('contract-codes-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Purpose</th>
                        <th>Created at</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($codes as $code)
                    <tr>
                        <td>{{$code->code}}</td>
                        <td>{{$code->purpose}}</td>
                        <td>{{$code->created_at}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection