@extends ('../welcome')


@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Clients</h3><br>
            <p>Total: {{ count($clients) }}</p>

            @if (auth()->user()->type == 'admin' ||
                    auth()->user()->role->hasPermission('clients-restoreAll'))
                <a href="{{ route('clients.restoreAll') }}" title="Restore All" style="float:right">
                    <button class="btn btn-square btn-outline-success" type="button"><i
                            class="fas fa-trash-restore-alt"></i></button>
                </a>
            @endif
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('clients-archive-export') ? 'example1' : 'nonExport' }} 
                class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Phone Number</th>
                        <th>Source</th>
                        <th>Created Date</th>
                        <th>Created Time</th>
                        @if (auth()->user()->type == 'admin')
                            <th style="display:none">Action</th>
                        @endif
                    </tr>
                </thead>
                <tbody>

                    @foreach ($clients as $client)
                        <?php $temp = explode(' ', $client->created_at->setTimezone('Africa/Cairo')); ?>

                        <tr>
                            <td>{{ $client->id }}</td>
                            <td>
                                {{ $client->name }}
                            </td>
                            <td>{{ $client->email }}</td>
                            <!-- Phone number -->
                            <td>
                                @foreach ($client->phone_numbers as $phone_number)
                                    <a href="https://wa.me/{{ $phone_number->country->phonecode }}{{ $phone_number->phone }}" target="_blank">
                                        {{ $phone_number->country->phonecode }} {{ $phone_number->phone }}
                                    </a>
                                    <br>
                                @endforeach
                            </td>
                            <td>{{ $client->came_from }}</td>
                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>
                            @if (auth()->user()->type == 'admin' ||
                                    auth()->user()->role->hasPermission('clients-restore'))
                                <td>
                                    <a class="btn btn-outline-light" title="Restore"
                                        href="{{ route('clients.restore', $client->id) }}">
                                        <i class="fas fa-trash-restore-alt"></i>
                                    </a>

                                </td>
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
@endsection
