@extends ('../welcome')


@section ('content')

<div class="card card-info">
    <div class="card-header">
        <h3 class="card-title">Update Phase</h3>
    </div>
    <!-- /.card-header -->
    <div class="card-body">

        <form action="{{ route('buildings.update', $building->id)}}" method="POST">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-sm-6">
                    <!-- text input -->
                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" name="name" class="form-control" value="{{$building->name}}" required>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">

                    <div class="form-group">
                        <select name="type" class="form-control">
                            <option value="Residential" {{$building->type == 'Residential' ? 'selected' : ''}}>
                                Residential</option>
                            <option value="Commercial" {{$building->type == 'Commercial' ? 'selected' : ''}}>Commercial
                            </option>
                            <option value="Administrative" {{$building->type == 'Administrative' ? 'selected' : ''}}>
                                Administrative</option>
                            <option value="Multiple" {{$building->type == 'Multiple' ? 'selected' : ''}}>
                                Multiple</option>
                        </select>
                    </div>
                </div>
            </div>
            
            
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Number of floors</label>
                        <input type="number" name="number_of_floors" class="form-control"
                            value="{{$building->number_of_floors}}">
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <div class="form-check">
                            <input class="form-check-input" name="is_active" value="1" type="checkbox"
                                {{$building->is_active == 1 ? 'checked': ''}}>
                            <label class="form-check-label">Active</label>
                        </div>
                    </div>
                </div>
            </div>
            <label style="color:red;">If new type Has Roof </label>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Add Roof Space</label>
                        <input type="number" step="any" name="roof_space" class="form-control" value="{{$building->roof_space}}">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        <label>Add Roof Percentage %</label>
                        <input type="number" step="any" name="roof_percentage" class="form-control"
                            value="{{$building->roof_percentage}}">
                    </div>
                </div>
            </div>
            <input type="hidden" name="phase_id" value="{{$phase->id}}">
            &nbsp&nbsp
            <button type="submit" class="btn btn-primary col start">
                <span>Submit</span>
            </button>

        </form>
    </div>
    <!-- /.card-body -->
</div>
@endsection