@extends ('../welcome')

@section('content')
    <style>
        h4 {
            font-size: 20px;
        }
    </style>
    <div class="card">
        <div class="card-header">
            <form action="{{ route('hideBuilding', $building->id) }}" method="POST">
                @csrf
                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-edit'))
                    <a href="{{ route('buildings.edit', $building->id) }}">
                        <button class="btn btn-square btn-info" type="button"><i class="fas fa-pen"></i></button>
                    </a>
                @endif

                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-delete'))
                    <button onClick="clickDeletebutton(this)" type="button" title="Delete" class="btn btn-danger"
                        data-id="{{ $building->id }}" data-toggle="modal" data-target="#buildingModal">
                        <i class="fa fa-ban"></i>
                    </button>
                @endif

                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('buildings-hide'))
                        <button type="submit" style="float:right"
                            class="btn btn-{{ $building->is_active == 0 ? 'light' : 'dark' }}"
                            title="{{ $building->is_active == 0 ? 'unhide' : 'hide' }}">
                            <i class="fas fa-{{ $building->is_active == 0 ? 'eye' : 'eye-slash' }}"></i>
                        </button>
                @endif
            </form>

        </div>
        <div class="card-body">
            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Building Name :</h4>
                <h4 class="col-form-h4">{{ $building->name }} </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Active :</h4>
                <h4 class="col-form-h4">{{ $building->is_active == 0 ? 'Not Available' : 'Available' }} </h4>
            </div>
            @if ($building->phase->project->is_residential == 1)
                <div class=" row">
                    <h4 style="font-weight:bold" class="col-3">Building Type :</h4>
                    <h4 class="col-form-h4">{{ $building->type }} </h4>
                </div>
                <div class=" row">
                    <h4 style="font-weight:bold" class="col-3">Number Of Floors :</h4>
                    <h4 class="col-form-h4">G+ {{ $building->number_of_floors }} </h4>
                </div>
            @endif
            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Phase Name :</h4>
                <h4 class="col-form-h4">
                    <a href="{{ route('phases.show', $building->phase->id) }}">
                        {{ $building->phase->name }}
                        {{ $building->phase->project->is_residential == 0 ? ' - ' . $building->phase->type : '' }}
                    </a>
                </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Project Name :</h4>
                <h4 class="col-form-h4">
                    <a href="{{ route('projects.show', $building->phase->project->id) }}">
                        {{ $building->phase->project->name }}
                    </a>
                </h4>
            </div>

            <div class=" row">
                <h4 style="font-weight:bold" class="col-3">Created at :</h4>
                <h4 class="col-form-h4">{{ $building->created_at }} </h4>
            </div>
        </div>
        <br>
    </div>

    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-read'))
        <div class="card">
            <div class="card-header">
                <h3 class="card-title" style="font-weight: bold;">Units
                    <p>Total: {{ count($units) }}</p>
                </h3>&nbsp; &nbsp;
                <div style="float:right">
                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-uploads'))
                        <a class="btn btn-secondary" data-toggle="modal" style="float:right" title="Import Units"
                            data-target='#UploadFileModal'>
                            <i class="fas fa-file-import"></i>
                        </a>
                    @endif

                    @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-create'))
                        <a href="{{ route('units.create', 'id=' . $building->id) }}" title="create unit">
                            <button class="btn btn-square btn-light active" type="button"><i
                                    class="fas fa-plus"></i></button>
                        </a>
                    @endif

                </div>
            </div>
            <div class="card-body">
                <table id={{ auth()->user()->type == 'admin' ||   auth()->user()->role->hasPermission('units-export') ? 'example1' : 'nonExport' }} 
                    class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            @if ($building->phase->project->is_residential == 1)
                                <th>Floor</th>
                            @endif
                            <th>Unit Total Price</th>
                            <th>Unit Space</th>
                            <th>Status</th>
                            <th>Client ID</th>
                            <th>Client Name</th>
                            <th>Created Date</th>
                            <th>Created Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($units as $unit)
                            <?php $temp = explode(' ', $unit->created_at); ?>
                            @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-show'))
                                <tr class='clickable-row' data-href='{{ route('units.show', $unit->id) }}'>
                                @else
                                <tr>
                            @endif
                            <td>{{ $unit->id }}</td>
                            <td>
                                <a href="{{ route('units.show', $unit->id) }}">
                                    {{ $unit->name }}
                                </a>
                            </td>

                            @if ($building->phase->project->is_residential == 1)
                                <td>{{ $unit->floor == 0 ? 'Ground' : $unit->floor }}</td>
                            @endif

                            <td>{{ $unit->unit_total_price }}</td>
                            <td>{{ $unit->unit_space }}</td>


                            <td>{{ $unit->status == 'taken' ? 'Contracted' : $unit->status }}</td>
                            <td>{{ $unit->client?->id ?? '' }}</td>
                            <td>{{ $unit->client?->name ?? '' }}</td>

                            <td>{{ $temp[0] }}</td>
                            <td>{{ $temp[1] }}</td>

                            <td>
                                @if (auth()->user()->type == 'admin' || auth()->user()->role->hasPermission('units-edit'))
                                    <a class="btn btn-info" title="Edit" href="{{ route('units.edit', $unit->id) }}">
                                        <i class="fa fa-pen"></i>
                                    </a>
                                @endif

                                @if ($unit->status == 'free')
                                    <a class="btn btn-{{ $unit->is_active == 0 ? 'info' : 'danger' }}"
                                        title="{{ $unit->is_active == 0 ? 'unhide' : 'hide' }}"
                                        href="{{ route('hideUnit', $unit->id) }}">
                                        {{ $unit->is_active == 0 ? 'unhide' : 'hide' }}
                                    </a>
                                @endif

                                {{-- @if (auth()->user()->role->hasPermission('units-delete'))
                                <button onClick="clickDeletebutton(this)" title="Delete" class="btn btn-danger"
                                    data-id="{{ $unit->id }}" data-toggle="modal" data-target="#exampleModalCenter">
                        <i class="fa fa-ban"></i>
                        </button>
                        @endif --}}
                            </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="modal fade" id="exampleModalCenter" tabindex="-1" role="dialog"
                    aria-labelledby="exampleModalCenter" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title">Delete Record</h5>
                            </div>
                            <div class="modal-body">
                                <p>Are you sure to delete this record ?</p>
                            </div>
                            <form class="modal-footer" method="post">
                                @csrf
                                @method('DELETE')
                                <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endif

    <div class="modal fade" id="buildingModal" tabindex="-1" role="dialog" aria-labelledby="buildingModal"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Delete Record</h5>
                </div>
                <div class="modal-body">
                    @if (count($building->units) == 0)
                        <p>Are you sure to delete this record ?</p>
                    @else
                        <p>this Building has units you can't delete this Building</p>
                    @endif
                </div>
                <form class="modal-footer" method="post">
                    @csrf
                    @method('DELETE')
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    @if (count($building->units) == 0)
                        <button type="submit" class="btn btn-primary yes" type="button">Yes</button>
                    @endif
                </form>
            </div>
        </div>
    </div>

    <form action="{{ route('units.import') }}" method="POST" enctype="multipart/form-data">
        <div class="modal fade" id="UploadFileModal" tabindex="-1" role="dialog" aria-labelledby="UploadFileModal"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Import Units</h5>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="upload-sheet" class="btn btn-outline-info" title="upload Sheet">
                                Upload Sheet &nbsp;
                            </label>
                            <input type="file" name="file" id="upload-sheet" style="display:none">
                        </div>
                    </div>
                    @csrf
                    <div class="modal-footer">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-info yes" type="button">import</button>
                    </div>

                </div>
            </div>
        </div>
    </form>

    <!-- /.row -->
    <script>
        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('units.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#exampleModalCenter').find($('form')).attr('action', route);
        }

        clickDeletebutton = (e) => {
            const modelId = e.getAttribute("data-id");
            var route = "{{ route('buildings.destroy', ':id') }}";
            route = route.replace(':id', modelId);
            $('#buildingModal').find($('form')).attr('action', route);
        }
    </script>
@endsection
